/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.http.HttpExchange;
import org.apache.camel.impl.DefaultMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpMessage
extends DefaultMessage {
    private HttpServletRequest request;

    public HttpMessage(HttpExchange exchange, HttpServletRequest request) {
        this.setExchange(exchange);
        this.request = request;
        this.getBody();
        this.getHeaders();
    }

    @Override
    public HttpExchange getExchange() {
        return (HttpExchange)super.getExchange();
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    @Override
    protected Object createBody() {
        try {
            return this.getExchange().getEndpoint().getBinding().parseBody(this);
        }
        catch (IOException e) {
            throw new RuntimeCamelException(e);
        }
    }

    @Override
    protected void populateInitialHeaders(Map<String, Object> map) {
        Enumeration names = this.request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = this.request.getHeader(name);
            map.put(name, value);
        }
    }
}

