/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.http.HttpEndpoint;
import org.apache.camel.component.http.HttpMessage;
import org.apache.camel.impl.DefaultExchange;

public class HttpExchange
extends DefaultExchange {
    private final HttpEndpoint endpoint;
    private HttpServletRequest request;
    private HttpServletResponse response;

    public HttpExchange(HttpEndpoint endpoint, ExchangePattern pattern) {
        super(endpoint.getContext(), pattern);
        this.endpoint = endpoint;
    }

    public HttpExchange(HttpEndpoint endpoint, HttpServletRequest request, HttpServletResponse response) {
        this(endpoint, HttpExchange.getPatternFromRequest(request));
        this.request = request;
        this.response = response;
        this.setIn(new HttpMessage(this, request));
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public HttpEndpoint getEndpoint() {
        return this.endpoint;
    }

    protected static ExchangePattern getPatternFromRequest(HttpServletRequest request) {
        return ExchangePattern.InOut;
    }
}

