/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.camel.Exchange;
import org.apache.camel.component.file.remote.RemoteFileExchange;
import org.apache.camel.component.file.remote.RemoteFileProducer;
import org.apache.camel.component.file.remote.SftpEndpoint;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SftpProducer
extends RemoteFileProducer<RemoteFileExchange> {
    private static final transient Log LOG = LogFactory.getLog(SftpProducer.class);
    SftpEndpoint endpoint;
    private ChannelSftp channel;
    private Session session;

    public SftpProducer(SftpEndpoint endpoint, Session session) {
        super(endpoint);
        this.endpoint = endpoint;
        this.session = session;
    }

    @Override
    protected void connectIfNecessary() throws JSchException {
        if (this.channel == null || !this.channel.isConnected()) {
            if (this.session == null || !this.session.isConnected()) {
                LOG.info((Object)"Session isn't connected, trying to recreate and connect...");
                this.session = this.endpoint.createSession();
                this.session.connect();
            }
            LOG.info((Object)"Channel isn't connected, trying to recreate and connect...");
            this.channel = this.endpoint.createChannelSftp(this.session);
            this.channel.connect();
            LOG.info((Object)("Connected to " + this.endpoint.getConfiguration().toString()));
        }
    }

    @Override
    protected void disconnect() throws JSchException {
        if (this.session != null) {
            LOG.info((Object)"Session is being explicitly disconnected");
            this.session.disconnect();
        }
        if (this.channel != null) {
            LOG.info((Object)"Channel is being explicitly disconnected");
            this.channel.disconnect();
        }
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        this.connectIfNecessary();
        try {
            this.process((RemoteFileExchange)this.endpoint.createExchange(exchange));
        }
        catch (JSchException e) {
            LOG.warn((Object)("Disconnecting due to exception: " + e.toString()));
            this.disconnect();
            throw e;
        }
        catch (SftpException e) {
            LOG.warn((Object)("Caught SftpException:" + e.toString()));
            LOG.warn((Object)"Doing nothing for now, need to determine an appropriate action");
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(RemoteFileExchange exchange) throws Exception {
        InputStream payload = exchange.getIn().getBody(InputStream.class);
        try {
            boolean success;
            String fileName = this.createFileName(exchange.getIn(), this.endpoint.getConfiguration());
            int lastPathIndex = fileName.lastIndexOf(47);
            if (lastPathIndex != -1 && !(success = SftpProducer.buildDirectory(this.channel, fileName.substring(0, lastPathIndex)))) {
                LOG.warn((Object)("Couldn't buildDirectory: " + fileName.substring(0, lastPathIndex) + " (either permissions deny it, or it already exists)"));
            }
            this.channel.put(payload, fileName);
            LOG.info((Object)("Sent: " + fileName + " to " + this.endpoint.getConfiguration()));
        }
        finally {
            if (null != payload) {
                payload.close();
            }
        }
    }

    @Override
    protected void doStart() throws Exception {
        LOG.info((Object)"Starting");
        try {
            this.connectIfNecessary();
        }
        catch (JSchException e) {
            LOG.warn((Object)("Couldn't connect to " + this.endpoint.getConfiguration()));
        }
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        LOG.info((Object)"Stopping");
        this.disconnect();
        super.doStop();
    }

    protected static boolean buildDirectory(ChannelSftp sftpClient, String dirName) throws IOException {
        String[] dirs;
        boolean atLeastOneSuccess = false;
        StringBuilder sb = new StringBuilder(dirName.length());
        for (String dir : dirs = dirName.split("\\/")) {
            sb.append(dir).append('/');
            try {
                sftpClient.mkdir(sb.toString());
                if (atLeastOneSuccess) continue;
                atLeastOneSuccess = true;
            }
            catch (SftpException e) {
                // empty catch block
            }
        }
        return atLeastOneSuccess;
    }
}

