/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import java.io.ByteArrayOutputStream;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.file.remote.RemoteFileBinding;
import org.apache.camel.component.file.remote.RemoteFileComponent;
import org.apache.camel.component.file.remote.RemoteFileConfiguration;
import org.apache.camel.component.file.remote.RemoteFileExchange;
import org.apache.camel.impl.ScheduledPollEndpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RemoteFileEndpoint<T extends RemoteFileExchange>
extends ScheduledPollEndpoint<T> {
    private RemoteFileBinding binding;
    private RemoteFileConfiguration configuration;

    public RemoteFileEndpoint(String uri, RemoteFileComponent component, RemoteFileConfiguration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    protected RemoteFileBinding createRemoteFileBinding() {
        return new RemoteFileBinding();
    }

    @Override
    public T createExchange() {
        return (T)new RemoteFileExchange<RemoteFileBinding>(this.getContext(), this.getExchangePattern(), this.getBinding());
    }

    @Override
    public T createExchange(ExchangePattern pattern) {
        return (T)new RemoteFileExchange<RemoteFileBinding>(this.getContext(), pattern, this.getBinding());
    }

    public T createExchange(String fullFileName, ByteArrayOutputStream outputStream) {
        return (T)new RemoteFileExchange<RemoteFileBinding>(this.getContext(), this.getExchangePattern(), this.getBinding(), this.getConfiguration().getHost(), fullFileName, outputStream);
    }

    public RemoteFileBinding getBinding() {
        if (this.binding == null) {
            this.binding = this.createRemoteFileBinding();
        }
        return this.binding;
    }

    public void setBinding(RemoteFileBinding binding) {
        this.binding = binding;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    public RemoteFileConfiguration getConfiguration() {
        return this.configuration;
    }
}

