/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import java.io.IOException;
import org.apache.camel.Processor;
import org.apache.camel.component.file.remote.FtpConsumer;
import org.apache.camel.component.file.remote.FtpProducer;
import org.apache.camel.component.file.remote.RemoteFileComponent;
import org.apache.camel.component.file.remote.RemoteFileConfiguration;
import org.apache.camel.component.file.remote.RemoteFileEndpoint;
import org.apache.camel.component.file.remote.RemoteFileExchange;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtpEndpoint
extends RemoteFileEndpoint<RemoteFileExchange> {
    private static final transient Log LOG = LogFactory.getLog(FtpEndpoint.class);

    public FtpEndpoint(String uri, RemoteFileComponent remoteFileComponent, RemoteFileConfiguration configuration) {
        super(uri, remoteFileComponent, configuration);
    }

    public FtpProducer createProducer() throws Exception {
        return new FtpProducer(this, this.createFtpClient());
    }

    public FtpConsumer createConsumer(Processor processor) throws Exception {
        FtpConsumer consumer = new FtpConsumer(this, processor, this.createFtpClient());
        this.configureConsumer(consumer);
        return consumer;
    }

    protected FTPClient createFtpClient() {
        FTPClient client = new FTPClient();
        return client;
    }

    public void connect(FTPClient client) throws IOException {
        RemoteFileConfiguration config = this.getConfiguration();
        String host = config.getHost();
        int port = config.getPort();
        client.connect(host, port);
        client.login(config.getUsername(), config.getPassword());
        client.setFileType(config.isBinary() ? 2 : 0);
    }

    public void disconnect(FTPClient client) throws IOException {
        client.disconnect();
    }
}

