/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class FileRouteTest
extends ContextTestSupport {
    protected Object expectedBody = "Hello there!";
    protected String uri = "file:target/test-default-inbox";

    public void testFileRoute() throws Exception {
        MockEndpoint result = this.resolveMandatoryEndpoint("mock:result", MockEndpoint.class);
        result.expectedBodiesReceived(this.expectedBody);
        result.setResultWaitTime(5000L);
        this.template.sendBodyAndHeader(this.uri, this.expectedBody, "cheese", (Object)123);
        result.assertIsSatisfied();
    }

    protected void setUp() throws Exception {
        FileRouteTest.deleteDirectory("target/test-default-inbox");
        super.setUp();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from(FileRouteTest.this.uri).to("mock:result");
            }
        };
    }
}

