/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import java.util.Collections;
import junit.framework.Assert;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.component.file.FileExchange;
import org.apache.camel.processor.Pipeline;

public class FileExchangeTest
extends ContextTestSupport {
    protected File file;
    protected ExchangePattern pattern = ExchangePattern.InOnly;

    public void testCopy() {
        FileExchange fileExchange = new FileExchange(this.context, this.pattern, this.file);
        Exchange exchange = fileExchange.copy();
        FileExchange copy = this.assertIsInstanceOf(FileExchange.class, exchange);
        FileExchangeTest.assertEquals((String)"File", (Object)this.file, (Object)copy.getFile());
        Object body = copy.getIn().getBody();
        FileExchangeTest.assertNotNull((String)"Should have a body!", (Object)body);
    }

    public void testCopyAfterBodyChanged() throws Exception {
        FileExchange original = new FileExchange(this.context, this.pattern, this.file);
        Integer expectedBody = 1234;
        original.getIn().setBody(expectedBody);
        Exchange exchange = original.copy();
        FileExchange copy = this.assertIsInstanceOf(FileExchange.class, exchange);
        FileExchangeTest.assertEquals((String)"File", (Object)this.file, (Object)copy.getFile());
        Object body = copy.getIn().getBody();
        FileExchangeTest.assertNotNull((String)"Should have a body!", (Object)body);
        FileExchangeTest.assertEquals((String)"Copied exchange in body", (Object)expectedBody, (Object)body);
    }

    public void testPipelineCopy() throws Exception {
        Processor myProcessor = new Processor(){

            public void process(Exchange exchange) throws Exception {
                Object body = exchange.getIn().getBody();
                Assert.assertNotNull((String)"Should have a body!", (Object)body);
            }
        };
        Pipeline pipeline = new Pipeline(Collections.singletonList(myProcessor));
        FileExchange exchange = new FileExchange(this.context, this.pattern, this.file);
        pipeline.process(exchange.copy());
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.file = new File(FileExchangeTest.class.getResource("FileExchangeTest.class").getFile());
    }
}

