/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.component.file.FileEndpoint;
import org.apache.camel.impl.DefaultMessage;

public class FileConfigureTest
extends ContextTestSupport {
    private static final String EXPECT_PATH = "target" + File.separator + "foo" + File.separator + "bar";
    private static final String EXPECT_FILE = "some" + File.separator + "nested" + File.separator + "filename.txt";

    public void testUriConfigurations() throws Exception {
        this.assertFileEndpoint("file://target/foo/bar", EXPECT_PATH);
        this.assertFileEndpoint("file://target/foo/bar?delete=true", EXPECT_PATH);
        this.assertFileEndpoint("file:target/foo/bar?delete=true", EXPECT_PATH);
        this.assertFileEndpoint("file:target/foo/bar", EXPECT_PATH);
        this.assertFileEndpoint("file://target/foo/bar/", EXPECT_PATH);
        this.assertFileEndpoint("file://target/foo/bar/?delete=true", EXPECT_PATH);
        this.assertFileEndpoint("file:target/foo/bar/?delete=true", EXPECT_PATH);
        this.assertFileEndpoint("file:target/foo/bar/", EXPECT_PATH);
        this.assertFileEndpoint("file:/target/foo/bar/", File.separator + EXPECT_PATH);
        this.assertFileEndpoint("file:/", File.separator);
        this.assertFileEndpoint("file:///", File.separator);
    }

    private void assertFileEndpoint(String endpointUri, String expectedPath) {
        FileEndpoint endpoint = this.resolveMandatoryEndpoint(endpointUri, FileEndpoint.class);
        FileConfigureTest.assertNotNull((String)("Could not find endpoint: " + endpointUri), (Object)endpoint);
        File file = endpoint.getFile();
        String path = file.getPath();
        FileConfigureTest.assertEquals((String)("For uri: " + endpointUri + " the file is not equal"), (String)expectedPath, (String)path);
        File consumedFile = new File(expectedPath + (expectedPath.endsWith(File.separator) ? "" : File.separator) + EXPECT_FILE);
        DefaultMessage message = new DefaultMessage();
        endpoint.configureMessage(consumedFile, message);
        FileConfigureTest.assertEquals((Object)EXPECT_FILE, (Object)message.getHeader("org.apache.camel.file.name"));
    }
}

