/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelTemplate;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.TestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.ProcessorType;
import org.apache.log4j.Logger;

public class DirectoryCreateIssueTest
extends TestSupport {
    private static final Logger LOG = Logger.getLogger(DirectoryCreateIssueTest.class);
    private CamelContext context;
    private CamelTemplate template;

    protected void setUp() throws Exception {
        super.setUp();
        this.context = new DefaultCamelContext();
        this.context.start();
        this.template = new CamelTemplate(this.context);
    }

    protected void tearDown() throws Exception {
        this.context.stop();
        super.tearDown();
    }

    public void testFileCreatedAsDir() throws Exception {
        this.log.debug((Object)"testFileCreatedAsDir");
        String path = "target/a/b/c/d/e/f/g/h";
        int numFiles = 10;
        this.context.addRoutes(new RouteBuilder(){

            public void configure() {
                String[] destinations = new String[10];
                for (int i = 0; i < 10; ++i) {
                    destinations[i] = "seda:file" + i;
                    ((ProcessorType)this.from("seda:file" + i).setHeader("org.apache.camel.file.name", this.constant("file" + i + ".txt"))).to("file://target/a/b/c/d/e/f/g/h/?append=false&noop=true");
                }
                this.from("seda:testFileCreatedAsDir").to(destinations);
            }
        });
        DirectoryCreateIssueTest.deleteDirectory(new File("a"));
        this.template.send("seda:testFileCreatedAsDir", new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setBody("Contents of test file");
            }
        });
        Thread.sleep(2000L);
        for (int i = 0; i < 10; ++i) {
            DirectoryCreateIssueTest.assertTrue((boolean)new File("target/a/b/c/d/e/f/g/h/file" + i + ".txt").isFile());
        }
    }
}

