/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dataset;

import javax.naming.Context;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.builder.PredicateBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.xml.XPathBuilder;
import org.apache.camel.component.dataset.DataSet;
import org.apache.camel.component.dataset.DataSetEndpoint;
import org.apache.camel.component.dataset.DataSetSupport;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ProcessorType;

public class CustomDataSetTest
extends ContextTestSupport {
    protected DataSet dataSet = new DataSetSupport(){
        Expression<Exchange> expression = new XPathBuilder("/message/@index").resultType(Long.class);

        public void assertMessageExpected(DataSetEndpoint dataSetEndpoint, Exchange expected, Exchange actual, long index) throws Exception {
            Predicate<Exchange> predicate = PredicateBuilder.isEqualTo(this.expression, ExpressionBuilder.constantExpression(index));
            CustomDataSetTest.this.log.debug((Object)("evaluating predicate: " + predicate));
            predicate.assertMatches("Actual: " + actual, actual);
        }

        protected Object createMessageBody(long messageIndex) {
            return "<message index='" + messageIndex + "'>someBody" + messageIndex + "</message>";
        }
    };

    public void testUsingCustomDataSet() throws Exception {
        MockEndpoint endpoint = this.getMockEndpoint("mock:results");
        endpoint.expectedMessageCount((int)this.dataSet.getSize());
        this.assertMockEndpointsSatisifed();
    }

    protected Context createJndiContext() throws Exception {
        Context context = super.createJndiContext();
        context.bind("foo", (Object)this.dataSet);
        return context;
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ProcessorType)this.from("dataset:foo").multicast().to("mock:results")).to("seda:foo");
                this.from("seda:foo").to("dataset:foo");
            }
        };
    }
}

