/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import javax.naming.Context;
import junit.framework.Assert;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.language.Simple;
import org.apache.camel.processor.BeanRouteTest;
import org.apache.camel.util.jndi.JndiContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExpressionAnnotationToDisambiguateMethodsTest
extends ContextTestSupport {
    private static final transient Log LOG = LogFactory.getLog(BeanRouteTest.class);
    protected MyBean myBean = new MyBean();

    public void testSendMessage() throws Exception {
        this.template.sendBodyAndHeader("direct:in", (Object)"<hello>world!</hello>", "foo", (Object)"bar");
        ExpressionAnnotationToDisambiguateMethodsTest.assertEquals((String)("bean body: " + this.myBean), (String)"bar", (String)this.myBean.bar);
    }

    protected Context createJndiContext() throws Exception {
        JndiContext answer = new JndiContext();
        answer.bind("myBean", (Object)this.myBean);
        return answer;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:in").beanRef("myBean");
            }
        };
    }

    public static class MyBean {
        public String bar;

        public void bar(String body) {
            Assert.fail((String)("bar() called with: " + body));
        }

        public void foo(@Simple(value="header.foo") String bar) {
            this.bar = bar;
            LOG.info((Object)("foo() method called with: " + bar));
        }

        public void wrongMethod(String body) {
            Assert.fail((String)("wrongMethod() called with: " + body));
        }
    }
}

