/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import javax.naming.Context;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.language.Simple;
import org.apache.camel.processor.BeanRouteTest;
import org.apache.camel.util.jndi.JndiContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BeanWithExpressionInjectionTest
extends ContextTestSupport {
    private static final transient Log LOG = LogFactory.getLog(BeanRouteTest.class);
    protected MyBean myBean = new MyBean();

    public void testSendMessage() throws Exception {
        String expectedBody = "Wobble";
        this.template.sendBodyAndHeader("direct:in", (Object)expectedBody, "foo", (Object)"bar");
        BeanWithExpressionInjectionTest.assertEquals((String)("bean body: " + this.myBean), (String)expectedBody, (String)this.myBean.body);
        BeanWithExpressionInjectionTest.assertEquals((String)("bean foo: " + this.myBean), (String)"bar", (String)this.myBean.foo);
    }

    protected Context createJndiContext() throws Exception {
        JndiContext answer = new JndiContext();
        answer.bind("myBean", (Object)this.myBean);
        return answer;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:in").beanRef("myBean");
            }
        };
    }

    public static class MyBean {
        public String body;
        public String foo;

        public String toString() {
            return "MyBean[foo: " + this.foo + " body: " + this.body + "]";
        }

        public void read(String body, @Simple(value="header.foo") String foo) {
            this.foo = foo;
            this.body = body;
            LOG.info((Object)("read() method called on " + this));
        }
    }
}

