/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import javax.naming.Context;
import junit.framework.Assert;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.processor.BeanRouteTest;
import org.apache.camel.util.jndi.JndiContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BeanMethodWithMultipleParametersTest
extends ContextTestSupport {
    private static final transient Log LOG = LogFactory.getLog(BeanRouteTest.class);
    protected MyBean myBean = new MyBean();

    public void testDummy() throws Exception {
    }

    public void xtestSendMessage() throws Exception {
        Object[] args = new Object[]{"abc", 5, "def"};
        this.template.sendBodyAndHeader("direct:in", (Object)args, "org.apache.camel.MethodName", (Object)"myMethod");
        BeanMethodWithMultipleParametersTest.assertEquals((String)"bean.foo", (String)"abc", (String)this.myBean.foo);
        BeanMethodWithMultipleParametersTest.assertEquals((String)"bean.bar", (int)5, (int)this.myBean.bar);
        BeanMethodWithMultipleParametersTest.assertEquals((String)"bean.x", (String)"def", (String)this.myBean.x);
    }

    protected Context createJndiContext() throws Exception {
        JndiContext answer = new JndiContext();
        answer.bind("myBean", (Object)this.myBean);
        return answer;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:in").to("bean:myBean?method=myMethod");
            }
        };
    }

    public static class MyBean {
        public String foo;
        public int bar;
        public String x;

        public String toString() {
            return "MyBean[foo: " + this.foo + " bar: " + this.bar + " x: " + this.x + "]";
        }

        public void myMethod(String foo, int bar, String x) {
            this.foo = foo;
            this.bar = bar;
            this.x = x;
            LOG.info((Object)("myMethod() method called on " + this));
        }

        public void anotherMethod(Object body) {
            Assert.fail((String)"Should not have called this method!");
        }
    }
}

