/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atom;

import java.util.Date;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.camel.component.atom.AtomEndpoint;
import org.apache.camel.component.atom.EntryFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdatedDateFilter
implements EntryFilter {
    private static final transient Log LOG = LogFactory.getLog(UpdatedDateFilter.class);
    private Date lastTime;

    @Override
    public boolean isValidEntry(AtomEndpoint endpoint, Document<Feed> feed, Entry entry) {
        Date updated = this.getUpdated(endpoint, feed, entry);
        if (updated == null) {
            this.warnNoUpdatedTime(endpoint, feed, entry);
            return true;
        }
        if (this.lastTime != null && this.lastTime.after(updated)) {
            return false;
        }
        this.lastTime = updated;
        return true;
    }

    protected Date getUpdated(AtomEndpoint endpoint, Document<Feed> feed, Entry entry) {
        Date answer = entry.getUpdated();
        if (answer == null && (answer = entry.getEdited()) == null) {
            answer = entry.getPublished();
        }
        return answer;
    }

    protected void warnNoUpdatedTime(AtomEndpoint endpoint, Document<Feed> feed, Entry entry) {
        LOG.warn((Object)("No updated time for entry so assuming new: " + entry));
    }
}

