/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atom;

import java.io.OutputStream;
import java.util.Date;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.camel.Exchange;
import org.apache.camel.component.atom.AtomEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomProducer
extends DefaultProducer {
    private static final transient Log LOG = LogFactory.getLog(AtomProducer.class);
    private final AtomEndpoint endpoint;

    public AtomProducer(AtomEndpoint endpoint) {
        super(endpoint);
        this.endpoint = endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Exchange exchange) throws Exception {
        Document<Feed> document = this.getDocument(exchange);
        OutputStream out = this.endpoint.createProducerOutputStream();
        try {
            document.writeTo(out);
        }
        finally {
            ObjectHelper.close(out, "Atom document output stream", LOG);
        }
    }

    protected Document<Feed> getDocument(Exchange exchange) throws Exception {
        String title;
        String summary;
        String content;
        Document<Feed> document = this.endpoint.parseDocument();
        Feed root = (Feed)document.getRoot();
        Entry entry = root.addEntry();
        entry.setPublished(ExchangeHelper.getExchangeProperty(exchange, "org.apache.camel.atom.published", Date.class, new Date()));
        String id = exchange.getProperty("org.apache.camel.atom.id", String.class);
        if (id != null) {
            entry.setId(id);
        }
        if ((content = exchange.getProperty("org.apache.camel.atom.content", String.class)) != null) {
            entry.setContent(content);
        }
        if ((summary = exchange.getProperty("org.apache.camel.atom.summary", String.class)) != null) {
            entry.setSummary(summary);
        }
        if ((title = exchange.getProperty("org.apache.camel.atom.title", String.class)) != null) {
            entry.setTitle(title);
        }
        return document;
    }
}

