/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.xml;

import javax.xml.xpath.XPathFunctionResolver;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.TestSupport;
import org.apache.camel.builder.xml.XPathBuilder;
import org.apache.camel.impl.DefaultCamelContext;

public class XPathTest
extends TestSupport {
    public void testXPathExpressions() throws Exception {
        this.assertExpression("/foo/bar/@xyz", "<foo><bar xyz='cheese'/></foo>", "cheese");
        this.assertExpression("$name", "<foo><bar xyz='cheese'/></foo>", "James");
        this.assertExpression("foo/bar", "<foo><bar>cheese</bar></foo>", "cheese");
        this.assertExpression("foo/bar/text()", "<foo><bar>cheese</bar></foo>", "cheese");
        this.assertExpression("/foo/@id", "<foo id='cheese'>hey</foo>", "cheese");
    }

    public void testXPathPredicates() throws Exception {
        this.assertPredicate("/foo/bar/@xyz", "<foo><bar xyz='cheese'/></foo>", true);
        this.assertPredicate("$name = 'James'", "<foo><bar xyz='cheese'/></foo>", true);
        this.assertPredicate("$name = 'Hiram'", "<foo><bar xyz='cheese'/></foo>", false);
        this.assertPredicate("/foo/notExist", "<foo><bar xyz='cheese'/></foo>", false);
    }

    public void testXPathWithCustomVariable() throws Exception {
        this.assertExpression(XPathBuilder.xpath("$name").stringResult().variable("name", "Hiram"), "<foo/>", "Hiram");
    }

    public void testUsingJavaExtensions() throws Exception {
        Object instance = null;
        try {
            instance = Class.forName("org.apache.xalan.extensions.XPathFunctionResolverImpl").newInstance();
        }
        catch (Throwable e) {
            this.log.debug((Object)("Could not find Xalan on the classpath so ignoring this test case: " + e));
        }
        if (instance instanceof XPathFunctionResolver) {
            XPathFunctionResolver functionResolver = instance;
            XPathBuilder builder = XPathBuilder.xpath("java:" + ((Object)((Object)this)).getClass().getName() + ".func(string(/header/value))").namespace("java", "http://xml.apache.org/xalan/java").functionResolver(functionResolver);
            String xml = "<header><value>12</value></header>";
            Object value = this.assertExpression(builder, xml, "modified12");
            this.log.debug((Object)("Evaluated xpath: " + builder.getText() + " on XML: " + xml + " result: " + value));
        }
    }

    public static String func(String s) {
        return "modified" + s;
    }

    protected Object assertExpression(String xpath, String xml, String expected) {
        XPathBuilder expression = XPathBuilder.xpath(xpath).stringResult();
        return this.assertExpression(expression, xml, expected);
    }

    protected Object assertExpression(Expression expression, String xml, String expected) {
        return this.assertExpression(expression, this.createExchange(xml), (Object)expected);
    }

    protected void assertPredicate(String xpath, String xml, boolean expected) {
        XPathBuilder predicate = XPathBuilder.xpath(xpath);
        this.assertPredicate(predicate, this.createExchange(xml), expected);
    }

    protected Exchange createExchange(String xml) {
        Exchange exchange = this.createExchangeWithBody(new DefaultCamelContext(), xml);
        exchange.getIn().setHeader("name", "James");
        return exchange;
    }
}

