/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Predicate;
import org.apache.camel.TestSupport;
import org.apache.camel.builder.Builder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.DefaultExchange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PredicateBuilderTest
extends TestSupport {
    protected Exchange exchange = new DefaultExchange(new DefaultCamelContext());

    public void testRegexPredicates() throws Exception {
        this.assertMatches(this.header("location").regex("[a-zA-Z]+,London,UK"));
        this.assertDoesNotMatch(this.header("location").regex("[a-zA-Z]+,Westminster,[a-zA-Z]+"));
    }

    public void testPredicates() throws Exception {
        this.assertMatches(this.header("name").isEqualTo(Builder.constant("James")));
    }

    public void testFailingPredicates() throws Exception {
        this.assertDoesNotMatch(this.header("name").isEqualTo(Builder.constant("Hiram")));
        this.assertDoesNotMatch(this.header("size").isGreaterThan(Builder.constant(100)));
    }

    protected void setUp() throws Exception {
        super.setUp();
        Message in = this.exchange.getIn();
        in.setBody("Hello there!");
        in.setHeader("name", "James");
        in.setHeader("location", "Islington,London,UK");
        in.setHeader("size", 10);
    }

    protected void assertMatches(Predicate<Exchange> predicate) {
        this.assertPredicateMatches(predicate, this.exchange);
    }

    protected void assertDoesNotMatch(Predicate<Exchange> predicate) {
        this.assertPredicateDoesNotMatch(predicate, this.exchange);
    }
}

