/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.ArrayList;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.TestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.ProcessorType;
import org.apache.camel.processor.DelegateProcessor;

public class InterceptorBuilderTest
extends TestSupport {
    public void testRouteWithInterceptor() throws Exception {
        DefaultCamelContext container = new DefaultCamelContext();
        final ArrayList order = new ArrayList();
        final DelegateProcessor interceptor1 = new DelegateProcessor(){

            public void process(Exchange exchange) throws Exception {
                order.add("START:1");
                super.process(exchange);
                order.add("END:1");
            }
        };
        final DelegateProcessor interceptor2 = new DelegateProcessor(){

            public void process(Exchange exchange) throws Exception {
                order.add("START:2");
                super.process(exchange);
                order.add("END:2");
            }
        };
        final Processor orderProcessor = new Processor(){

            public void process(Exchange exchange) {
                order.add("INVOKED");
            }
        };
        final Processor toProcessor = new Processor(){

            public void process(Exchange exchange) {
                order.add("TO");
            }
        };
        RouteBuilder builder = new RouteBuilder(){

            public void configure() {
                ((ProcessorType)((ProcessorType)((ProcessorType)this.from("direct:a").intercept(interceptor1)).process(orderProcessor)).intercept(interceptor2)).process(toProcessor);
            }
        };
        container.addRoutes(builder);
        container.start();
        Endpoint endpoint = container.getEndpoint("direct:a");
        Object exchange = endpoint.createExchange();
        Producer producer = endpoint.createProducer();
        producer.process((Exchange)exchange);
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("START:1");
        expected.add("INVOKED");
        expected.add("START:2");
        expected.add("TO");
        expected.add("END:2");
        expected.add("END:1");
        this.log.debug((Object)("Interceptor invocation order:" + order));
        InterceptorBuilderTest.assertEquals(expected, order);
    }
}

