/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.Arrays;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Predicate;
import org.apache.camel.TestSupport;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.builder.PredicateBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.DefaultExchange;

public class ExpressionBuilderTest
extends TestSupport {
    protected Exchange exchange = new DefaultExchange(new DefaultCamelContext());

    public void testRegexTokenize() throws Exception {
        Expression expression = ExpressionBuilder.regexTokenize(ExpressionBuilder.headerExpression("location"), ",");
        this.assertExpression(expression, this.exchange, Arrays.asList("Islington", "London", "UK"));
        Predicate predicate = PredicateBuilder.contains(ExpressionBuilder.regexTokenize(ExpressionBuilder.headerExpression("location"), ","), ExpressionBuilder.constantExpression("London"));
        this.assertPredicate(predicate, this.exchange, true);
        predicate = PredicateBuilder.contains(ExpressionBuilder.regexTokenize(ExpressionBuilder.headerExpression("location"), ","), ExpressionBuilder.constantExpression("Manchester"));
        this.assertPredicate(predicate, this.exchange, false);
    }

    public void testRegexReplaceAll() throws Exception {
        Expression expression = ExpressionBuilder.regexReplaceAll(ExpressionBuilder.headerExpression("location"), "London", "Westminster");
        this.assertExpression(expression, this.exchange, "Islington,Westminster,UK");
        expression = ExpressionBuilder.regexReplaceAll(ExpressionBuilder.headerExpression("location"), "London", ExpressionBuilder.headerExpression("name"));
        this.assertExpression(expression, this.exchange, "Islington,James,UK");
    }

    protected void setUp() throws Exception {
        super.setUp();
        Message in = this.exchange.getIn();
        in.setBody("Hello there!");
        in.setHeader("name", "James");
        in.setHeader("location", "Islington,London,UK");
    }
}

