/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.List;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.TestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.EventDrivenConsumerRoute;
import org.apache.camel.model.ProcessorType;
import org.apache.camel.processor.DeadLetterChannel;
import org.apache.camel.processor.FilterProcessor;
import org.apache.camel.processor.LoggingErrorHandler;
import org.apache.camel.processor.RedeliveryPolicy;
import org.apache.camel.processor.SendProcessor;

public class ErrorHandlerTest
extends TestSupport {
    public void xtestOverloadingTheDefaultErrorHandler() throws Exception {
        RouteBuilder builder = new RouteBuilder(){

            public void configure() {
                this.errorHandler(this.loggingErrorHandler("FOO.BAR"));
                this.from("seda:a").to("seda:b");
            }
        };
        List<Route> list = this.getRouteList(builder);
        ErrorHandlerTest.assertEquals((String)("Number routes created\u00a0" + list), (int)1, (int)list.size());
        for (Route route : list) {
            Endpoint key = route.getEndpoint();
            ErrorHandlerTest.assertEquals((String)"From endpoint", (String)"seda:a", (String)key.getEndpointUri());
            EventDrivenConsumerRoute consumerRoute = this.assertIsInstanceOf(EventDrivenConsumerRoute.class, route);
            Processor processor = consumerRoute.getProcessor();
            LoggingErrorHandler loggingProcessor = this.assertIsInstanceOf(LoggingErrorHandler.class, processor);
            SendProcessor sendProcessor = this.assertIsInstanceOf(SendProcessor.class, loggingProcessor.getOutput());
            this.log.debug((Object)("Found sendProcessor: " + sendProcessor));
        }
    }

    public void testOverloadingTheHandlerOnASingleRoute() throws Exception {
        RouteBuilder builder = new RouteBuilder(){

            public void configure() {
                ((ProcessorType)this.from("seda:a").errorHandler(this.loggingErrorHandler("FOO.BAR"))).to("seda:b");
                this.from("seda:b").to("seda:c");
            }
        };
        List<Route> list = this.getRouteList(builder);
        ErrorHandlerTest.assertEquals((String)("Number routes created\u00a0" + list), (int)2, (int)list.size());
        for (Route route : list) {
            Processor outputProcessor;
            Endpoint key = route.getEndpoint();
            String endpointUri = key.getEndpointUri();
            EventDrivenConsumerRoute consumerRoute = this.assertIsInstanceOf(EventDrivenConsumerRoute.class, route);
            Processor processor = this.unwrap(consumerRoute.getProcessor());
            SendProcessor sendProcessor = null;
            if (endpointUri.equals("seda:a")) {
                LoggingErrorHandler loggingProcessor = this.assertIsInstanceOf(LoggingErrorHandler.class, processor);
                outputProcessor = loggingProcessor.getOutput();
                sendProcessor = this.assertIsInstanceOf(SendProcessor.class, outputProcessor);
            } else {
                ErrorHandlerTest.assertEquals((String)"From endpoint", (String)"seda:b", (String)endpointUri);
                DeadLetterChannel deadLetterChannel = this.assertIsInstanceOf(DeadLetterChannel.class, processor);
                outputProcessor = deadLetterChannel.getOutput();
                sendProcessor = this.assertIsInstanceOf(SendProcessor.class, outputProcessor);
            }
            this.log.debug((Object)("For " + endpointUri + " using: " + sendProcessor));
        }
    }

    public void testConfigureDeadLetterChannel() throws Exception {
        RouteBuilder builder = new RouteBuilder(){

            public void configure() {
                this.errorHandler(this.deadLetterChannel("seda:errors"));
                this.from("seda:a").to("seda:b");
            }
        };
        List<Route> list = this.getRouteList(builder);
        ErrorHandlerTest.assertEquals((String)("Number routes created\u00a0" + list), (int)1, (int)list.size());
        for (Route route : list) {
            Endpoint key = route.getEndpoint();
            ErrorHandlerTest.assertEquals((String)"From endpoint", (String)"seda:a", (String)key.getEndpointUri());
            EventDrivenConsumerRoute consumerRoute = this.assertIsInstanceOf(EventDrivenConsumerRoute.class, route);
            Processor processor = this.unwrap(consumerRoute.getProcessor());
            this.assertIsInstanceOf(DeadLetterChannel.class, processor);
        }
    }

    public void xtestConfigureDeadLetterChannelWithCustomRedeliveryPolicy() throws Exception {
        RouteBuilder builder = new RouteBuilder(){

            public void configure() {
                this.errorHandler(this.deadLetterChannel("seda:errors").maximumRedeliveries(2).useExponentialBackOff());
                this.from("seda:a").to("seda:b");
            }
        };
        List<Route> list = this.getRouteList(builder);
        ErrorHandlerTest.assertEquals((String)("Number routes created\u00a0" + list), (int)1, (int)list.size());
        for (Route route : list) {
            Endpoint key = route.getEndpoint();
            ErrorHandlerTest.assertEquals((String)"From endpoint", (String)"seda:a", (String)key.getEndpointUri());
            EventDrivenConsumerRoute consumerRoute = this.assertIsInstanceOf(EventDrivenConsumerRoute.class, route);
            Processor processor = consumerRoute.getProcessor();
            DeadLetterChannel deadLetterChannel = this.assertIsInstanceOf(DeadLetterChannel.class, processor);
            RedeliveryPolicy redeliveryPolicy = deadLetterChannel.getRedeliveryPolicy();
            ErrorHandlerTest.assertEquals((String)"getMaximumRedeliveries()", (int)2, (int)redeliveryPolicy.getMaximumRedeliveries());
            ErrorHandlerTest.assertEquals((String)"isUseExponentialBackOff()", (boolean)true, (boolean)redeliveryPolicy.isUseExponentialBackOff());
        }
    }

    public void testDisablingInheritenceOfErrorHandlers() throws Exception {
        RouteBuilder builder = new RouteBuilder(){

            public void configure() {
                ((ProcessorType)((ProcessorType)this.from("seda:a").errorHandler(this.loggingErrorHandler("FOO.BAR"))).filter(this.body().isInstanceOf(String.class)).inheritErrorHandler(false)).to("seda:b");
            }
        };
        List<Route> routes = this.getRouteList(builder);
        ErrorHandlerTest.assertEquals((String)"Number routes created", (int)1, (int)routes.size());
        for (Route route : routes) {
            Endpoint key = route.getEndpoint();
            ErrorHandlerTest.assertEquals((String)"From endpoint", (String)"seda:a", (String)key.getEndpointUri());
            EventDrivenConsumerRoute consumerRoute = this.assertIsInstanceOf(EventDrivenConsumerRoute.class, route);
            Processor processor = this.unwrap(consumerRoute.getProcessor());
            LoggingErrorHandler loggingProcessor = this.assertIsInstanceOf(LoggingErrorHandler.class, processor);
            FilterProcessor filterProcessor = this.assertIsInstanceOf(FilterProcessor.class, loggingProcessor.getOutput());
            SendProcessor sendProcessor = this.assertIsInstanceOf(SendProcessor.class, filterProcessor.getProcessor());
            this.log.debug((Object)("Found sendProcessor: " + sendProcessor));
        }
    }
}

