/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.TestSupport;
import org.apache.camel.ValidationException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.ChoiceType;
import org.apache.camel.model.ProcessorType;
import org.apache.camel.model.TryType;
import org.apache.camel.processor.DelegateProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuilderWithScopesTest
extends TestSupport {
    final ArrayList<String> order = new ArrayList();
    final DelegateProcessor interceptor1 = new DelegateProcessor(){

        public void process(Exchange exchange) throws Exception {
            BuilderWithScopesTest.this.order.add("START:1");
            super.process(exchange);
            BuilderWithScopesTest.this.order.add("END:1");
        }
    };
    final DelegateProcessor interceptor2 = new DelegateProcessor(){

        public void process(Exchange exchange) throws Exception {
            BuilderWithScopesTest.this.order.add("START:2");
            super.process(exchange);
            BuilderWithScopesTest.this.order.add("END:2");
        }
    };
    final Processor orderProcessor = new Processor(){

        public void process(Exchange exchange) {
            BuilderWithScopesTest.this.order.add("INVOKED");
        }
    };
    final Processor orderProcessor2 = new Processor(){

        public void process(Exchange exchange) {
            BuilderWithScopesTest.this.order.add("INVOKED2");
        }
    };
    final Processor orderProcessor3 = new Processor(){

        public void process(Exchange exchange) {
            BuilderWithScopesTest.this.order.add("INVOKED3");
        }
    };
    final Processor toProcessor = new Processor(){

        public void process(Exchange exchange) {
            BuilderWithScopesTest.this.order.add("TO");
        }
    };
    final Processor validator = new Processor(){

        public void process(Exchange exchange) throws Exception {
            BuilderWithScopesTest.this.order.add("VALIDATE");
            Object value = exchange.getIn().getHeader("foo");
            if (value == null) {
                throw new IllegalArgumentException("The foo header is not present.");
            }
            if (!value.equals("bar")) {
                throw new ValidationException(exchange, "The foo header does not equal bar! Was: " + value);
            }
        }
    };

    protected void runTest(RouteBuilder builder, ArrayList<String> expected) throws Exception {
        this.runTest(builder, expected, null);
    }

    protected void runTest(RouteBuilder builder, ArrayList<String> expected, String header) throws Exception {
        this.order.clear();
        DefaultCamelContext container = new DefaultCamelContext();
        container.addRoutes(builder);
        container.start();
        Endpoint endpoint = container.getEndpoint("direct:a");
        Object exchange = endpoint.createExchange();
        if (header != null) {
            exchange.getIn().setHeader("foo", header);
        }
        Producer producer = endpoint.createProducer();
        producer.process((Exchange)exchange);
        this.log.debug((Object)("Interceptor invocation order:" + this.order));
        BuilderWithScopesTest.assertEquals(expected, this.order);
    }

    public void testRouteWithFilterEnd() throws Exception {
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("TO");
        this.runTest(new RouteBuilder(){

            public void configure() {
                ((ProcessorType)this.from("direct:a").filter(this.header("foo").isEqualTo("bar")).process(BuilderWithScopesTest.this.orderProcessor)).end().process(BuilderWithScopesTest.this.toProcessor);
            }
        }, expected, "banana");
    }

    public void testRouteWithFilterNoEnd() throws Exception {
        ArrayList<String> expected = new ArrayList<String>();
        this.runTest(new RouteBuilder(){

            public void configure() {
                ((ProcessorType)this.from("direct:a").filter(this.header("foo").isEqualTo("bar")).process(BuilderWithScopesTest.this.orderProcessor)).process(BuilderWithScopesTest.this.toProcessor);
            }
        }, expected, "banana");
    }

    protected RouteBuilder createChoiceBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ChoiceType)((ChoiceType)this.from("direct:a").choice().when(this.header("foo").isEqualTo("bar")).process(BuilderWithScopesTest.this.orderProcessor)).when(this.header("foo").isEqualTo("cheese")).process(BuilderWithScopesTest.this.orderProcessor2)).end().process(BuilderWithScopesTest.this.toProcessor);
            }
        };
    }

    public void testRouteWithChoice1() throws Exception {
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("INVOKED");
        expected.add("TO");
        this.runTest(this.createChoiceBuilder(), expected, "bar");
    }

    public void testRouteWithChoice2() throws Exception {
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("INVOKED2");
        expected.add("TO");
        this.runTest(this.createChoiceBuilder(), expected, "cheese");
    }

    public void testRouteWithChoice3() throws Exception {
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("TO");
        this.runTest(this.createChoiceBuilder(), expected, "banana");
    }

    public void testRouteWithChoiceNoEnd() throws Exception {
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("INVOKED");
        this.runTest(new RouteBuilder(){

            public void configure() {
                ((ChoiceType)((ChoiceType)this.from("direct:a").choice().when(this.header("foo").isEqualTo("bar")).process(BuilderWithScopesTest.this.orderProcessor)).when(this.header("foo").isEqualTo("cheese")).process(BuilderWithScopesTest.this.orderProcessor2)).process(BuilderWithScopesTest.this.toProcessor);
            }
        }, expected, "bar");
    }

    protected RouteBuilder createChoiceWithOtherwiseBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ChoiceType)((ChoiceType)((ChoiceType)this.from("direct:a").choice().when(this.header("foo").isEqualTo("bar")).process(BuilderWithScopesTest.this.orderProcessor)).when(this.header("foo").isEqualTo("cheese")).process(BuilderWithScopesTest.this.orderProcessor2)).otherwise().process(BuilderWithScopesTest.this.orderProcessor3)).end().process(BuilderWithScopesTest.this.toProcessor);
            }
        };
    }

    public void testRouteWithChoiceOtherwise1() throws Exception {
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("INVOKED");
        expected.add("TO");
        this.runTest(this.createChoiceWithOtherwiseBuilder(), expected, "bar");
    }

    public void testRouteWithChoiceOtherwise2() throws Exception {
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("INVOKED2");
        expected.add("TO");
        this.runTest(this.createChoiceWithOtherwiseBuilder(), expected, "cheese");
    }

    public void testRouteWithChoiceOtherwise3() throws Exception {
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("INVOKED3");
        expected.add("TO");
        this.runTest(this.createChoiceWithOtherwiseBuilder(), expected, "banana");
    }

    public void testRouteWithChoiceOtherwiseNoEnd() throws Exception {
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("INVOKED");
        this.runTest(new RouteBuilder(){

            public void configure() {
                ((ChoiceType)((ChoiceType)((ChoiceType)this.from("direct:a").choice().when(this.header("foo").isEqualTo("bar")).process(BuilderWithScopesTest.this.orderProcessor)).when(this.header("foo").isEqualTo("cheese")).process(BuilderWithScopesTest.this.orderProcessor2)).otherwise().process(BuilderWithScopesTest.this.orderProcessor3)).process(BuilderWithScopesTest.this.toProcessor);
            }
        }, expected, "bar");
    }

    protected RouteBuilder createTryCatchNoEnd() {
        return new RouteBuilder(){

            public void configure() {
                ((TryType)((TryType)((TryType)this.from("direct:a").tryBlock().process(BuilderWithScopesTest.this.validator)).process(BuilderWithScopesTest.this.toProcessor)).handle(ValidationException.class).process(BuilderWithScopesTest.this.orderProcessor)).process(BuilderWithScopesTest.this.orderProcessor3);
            }
        };
    }

    public void testRouteWithTryCatchNoEndNoException() throws Exception {
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("VALIDATE");
        expected.add("TO");
        this.runTest(this.createTryCatchNoEnd(), expected, "bar");
    }

    public void testRouteWithTryCatchNoEndWithCaughtException() throws Exception {
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("VALIDATE");
        expected.add("INVOKED");
        expected.add("INVOKED3");
        this.runTest(this.createTryCatchNoEnd(), expected, "banana");
    }

    public void testRouteWithTryCatchNoEndWithUncaughtException() throws Exception {
        ArrayList<String> expected = new ArrayList<String>();
        expected.addAll(Collections.nCopies(6, "VALIDATE"));
        this.runTest(this.createTryCatchNoEnd(), expected);
    }

    protected RouteBuilder createTryCatchEnd() {
        return new RouteBuilder(){

            public void configure() {
                ((TryType)((TryType)((TryType)this.from("direct:a").tryBlock().process(BuilderWithScopesTest.this.validator)).process(BuilderWithScopesTest.this.toProcessor)).handle(ValidationException.class).process(BuilderWithScopesTest.this.orderProcessor)).end().process(BuilderWithScopesTest.this.orderProcessor3);
            }
        };
    }

    public void testRouteWithTryCatchEndNoException() throws Exception {
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("VALIDATE");
        expected.add("TO");
        expected.add("INVOKED3");
        this.runTest(this.createTryCatchEnd(), expected, "bar");
    }

    public void testRouteWithTryCatchEndWithCaughtException() throws Exception {
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("VALIDATE");
        expected.add("INVOKED");
        expected.add("INVOKED3");
        this.runTest(this.createTryCatchEnd(), expected, "banana");
    }

    public void testRouteWithTryCatchEndWithUncaughtException() throws Exception {
        ArrayList<String> expected = new ArrayList<String>();
        expected.addAll(Collections.nCopies(6, "VALIDATE"));
        this.runTest(this.createTryCatchEnd(), expected);
    }

    protected RouteBuilder createTryCatchFinallyNoEnd() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler(this.deadLetterChannel().maximumRedeliveries(2));
                ((TryType)((TryType)((TryType)((TryType)this.from("direct:a").tryBlock().process(BuilderWithScopesTest.this.validator)).process(BuilderWithScopesTest.this.toProcessor)).handle(ValidationException.class).process(BuilderWithScopesTest.this.orderProcessor)).finallyBlock().process(BuilderWithScopesTest.this.orderProcessor2)).process(BuilderWithScopesTest.this.orderProcessor3);
            }
        };
    }

    public void testRouteWithTryCatchFinallyNoEndNoException() throws Exception {
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("VALIDATE");
        expected.add("TO");
        expected.add("INVOKED2");
        expected.add("INVOKED3");
        this.runTest(this.createTryCatchFinallyNoEnd(), expected, "bar");
    }

    public void testRouteWithTryCatchFinallyNoEndWithCaughtException() throws Exception {
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("VALIDATE");
        expected.add("INVOKED");
        expected.add("INVOKED2");
        expected.add("INVOKED3");
        this.runTest(this.createTryCatchFinallyNoEnd(), expected, "banana");
    }

    public void testRouteWithTryCatchFinallyNoEndWithUncaughtException() throws Exception {
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("VALIDATE");
        expected.add("INVOKED2");
        expected.add("INVOKED3");
        expected.add("VALIDATE");
        expected.add("INVOKED2");
        expected.add("INVOKED3");
        this.runTest(this.createTryCatchFinallyNoEnd(), expected);
    }

    protected RouteBuilder createTryCatchFinallyEnd() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler(this.deadLetterChannel().maximumRedeliveries(2));
                ((TryType)((TryType)((TryType)((TryType)this.from("direct:a").tryBlock().process(BuilderWithScopesTest.this.validator)).process(BuilderWithScopesTest.this.toProcessor)).handle(ValidationException.class).process(BuilderWithScopesTest.this.orderProcessor)).finallyBlock().process(BuilderWithScopesTest.this.orderProcessor2)).end().process(BuilderWithScopesTest.this.orderProcessor3);
            }
        };
    }

    public void testRouteWithTryCatchFinallyEndNoException() throws Exception {
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("VALIDATE");
        expected.add("TO");
        expected.add("INVOKED2");
        expected.add("INVOKED3");
        this.runTest(this.createTryCatchFinallyEnd(), expected, "bar");
    }

    public void testRouteWithTryCatchFinallyEndWithCaughtException() throws Exception {
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("VALIDATE");
        expected.add("INVOKED");
        expected.add("INVOKED2");
        expected.add("INVOKED3");
        this.runTest(this.createTryCatchFinallyEnd(), expected, "banana");
    }

    public void testRouteWithTryCatchFinallyEndWithUncaughtException() throws Exception {
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("VALIDATE");
        expected.add("INVOKED2");
        expected.add("VALIDATE");
        expected.add("INVOKED2");
        this.runTest(this.createTryCatchFinallyEnd(), expected);
    }
}

