/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.IdentifiedType;
import org.apache.camel.model.RouteContainer;
import org.apache.camel.model.RouteType;
import org.apache.camel.spi.InstrumentationAgent;
import org.apache.camel.spring.CamelBeanPostProcessor;
import org.apache.camel.spring.CamelProxyFactoryType;
import org.apache.camel.spring.CamelServiceExporterType;
import org.apache.camel.spring.EndpointFactoryBean;
import org.apache.camel.spring.RouteBuilderFinder;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.spring.SpringInstrumentationAgent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="camelContext")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CamelContextFactoryBean
extends IdentifiedType
implements RouteContainer,
FactoryBean,
InitializingBean,
DisposableBean,
ApplicationContextAware,
ApplicationListener {
    private static final Log LOG = LogFactory.getLog(CamelContextFactoryBean.class);
    @XmlElement(name="package", required=false)
    private String[] packages = new String[0];
    @XmlElements(value={@XmlElement(name="beanPostProcessor", type=CamelBeanPostProcessor.class, required=false), @XmlElement(name="proxy", type=CamelProxyFactoryType.class, required=false), @XmlElement(name="export", type=CamelServiceExporterType.class, required=false), @XmlElement(name="jmxAgent", required=false)})
    private List beans;
    @XmlElement(name="endpoint", required=false)
    private List<EndpointFactoryBean> endpoints;
    @XmlElement(name="route", required=false)
    private List<RouteType> routes = new ArrayList<RouteType>();
    @XmlAttribute(required=false)
    private Boolean useJmx;
    @XmlAttribute(required=false)
    private String mbeanServer;
    @XmlTransient
    private SpringCamelContext context;
    @XmlTransient
    private RouteBuilder routeBuilder;
    @XmlTransient
    private List<RouteBuilder> additionalBuilders = new ArrayList<RouteBuilder>();
    @XmlTransient
    private ApplicationContext applicationContext;
    @XmlTransient
    private ClassLoader contextClassLoaderOnStart = Thread.currentThread().getContextClassLoader();
    @XmlTransient
    private InstrumentationAgent instrumentationAgent;

    public Object getObject() throws Exception {
        return this.getContext();
    }

    public Class getObjectType() {
        return SpringCamelContext.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        this.getContext().addRouteDefinitions(this.routes);
        if (this.instrumentationAgent == null && this.isJmxEnabled()) {
            SpringInstrumentationAgent agent = new SpringInstrumentationAgent();
            agent.setCamelContext(this.getContext());
            String name = this.getMbeanServer();
            if (name != null) {
                MBeanServer mbeanServer = (MBeanServer)this.getApplicationContext().getBean(name, MBeanServer.class);
                agent.setMBeanServer(mbeanServer);
            }
            this.instrumentationAgent = agent;
            this.instrumentationAgent.start();
        }
        LOG.debug("Found JAXB created routes: " + this.getRoutes());
        this.findRouteBuiders();
        this.installRoutes();
    }

    public void destroy() throws Exception {
        this.getContext().stop();
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Publishing event: " + event);
        }
        if (event instanceof ContextRefreshedEvent) {
            try {
                LOG.debug("Starting the context now!");
                this.getContext().start();
            }
            catch (Exception e) {
                throw new RuntimeCamelException(e);
            }
        }
    }

    public SpringCamelContext getContext() throws Exception {
        if (this.context == null) {
            this.context = this.createContext();
        }
        return this.context;
    }

    public void setContext(SpringCamelContext context) {
        this.context = context;
    }

    @Override
    public List<RouteType> getRoutes() {
        return this.routes;
    }

    @Override
    public void setRoutes(List<RouteType> routes) {
        this.routes = routes;
    }

    public RouteBuilder getRouteBuilder() {
        return this.routeBuilder;
    }

    public void setRouteBuilder(RouteBuilder routeBuilder) {
        this.routeBuilder = routeBuilder;
    }

    public void setRouteBuilders(RouteBuilder[] builders) {
        for (RouteBuilder builder : builders) {
            this.additionalBuilders.add(builder);
        }
    }

    public ApplicationContext getApplicationContext() {
        if (this.applicationContext == null) {
            throw new IllegalArgumentException("No applicationContext has been injected!");
        }
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public String[] getPackages() {
        return this.packages;
    }

    public void setPackages(String[] packages) {
        this.packages = packages;
    }

    public String getMbeanServer() {
        return this.mbeanServer;
    }

    public void setMbeanServer(String mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    public boolean isJmxEnabled() {
        return this.useJmx != null && this.useJmx != false;
    }

    public Boolean getUseJmx() {
        return this.useJmx;
    }

    public void setUseJmx(Boolean useJmx) {
        this.useJmx = useJmx;
    }

    protected SpringCamelContext createContext() {
        SpringCamelContext ctx = new SpringCamelContext(this.getApplicationContext());
        ctx.setName(this.getId());
        return ctx;
    }

    protected void installRoutes() throws Exception {
        Map builders = this.getApplicationContext().getBeansOfType(RouteBuilder.class, true, true);
        if (builders != null) {
            for (Object builder : builders.values()) {
                this.getContext().addRoutes((RouteBuilder)builder);
            }
        }
        for (RouteBuilder routeBuilder : this.additionalBuilders) {
            this.getContext().addRoutes(routeBuilder);
        }
        if (this.routeBuilder != null) {
            this.getContext().addRoutes(this.routeBuilder);
        }
    }

    protected void findRouteBuiders() throws Exception, InstantiationException {
        if (this.packages != null && this.packages.length > 0) {
            RouteBuilderFinder finder = new RouteBuilderFinder(this.getContext(), this.packages, this.contextClassLoaderOnStart);
            finder.appendBuilders(this.additionalBuilders);
        }
    }
}

