/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.processor.CatchProcessor;
import org.apache.camel.processor.DeadLetterChannel;
import org.apache.camel.util.ServiceHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TryProcessor
extends ServiceSupport
implements Processor {
    private static final Log LOG = LogFactory.getLog(TryProcessor.class);
    private final Processor tryProcessor;
    private final List<CatchProcessor> catchClauses;
    private final Processor finallyProcessor;

    public TryProcessor(Processor tryProcessor, List<CatchProcessor> catchClauses, Processor finallyProcessor) {
        this.tryProcessor = tryProcessor;
        this.catchClauses = catchClauses;
        this.finallyProcessor = finallyProcessor;
    }

    public String toString() {
        String finallyText = this.finallyProcessor == null ? "" : " Finally {" + this.finallyProcessor + "}";
        return "Try {" + this.tryProcessor + "} " + this.catchClauses + finallyText;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        Throwable e = null;
        try {
            this.tryProcessor.process(exchange);
            e = exchange.getException();
            if (e != null && DeadLetterChannel.isFailureHandled(exchange)) {
                e = null;
            }
        }
        catch (Exception ex) {
            e = ex;
            exchange.setException(e);
        }
        if (e != null) {
            try {
                DeadLetterChannel.setFailureHandled(exchange, true);
                this.handleException(exchange, e);
            }
            catch (Exception ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new RuntimeCamelException(ex);
            }
            finally {
                this.handleAll(exchange);
            }
        } else {
            this.handleAll(exchange);
        }
    }

    private void handleAll(Exchange exchange) {
        if (this.finallyProcessor != null) {
            DeadLetterChannel.setFailureHandled(exchange, true);
            try {
                this.finallyProcessor.process(exchange);
            }
            catch (Exception e2) {
                LOG.warn("Caught exception in finally block while handling other exception: " + e2, e2);
            }
        }
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startServices(this.tryProcessor, this.catchClauses, this.finallyProcessor);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopServices(this.tryProcessor, this.catchClauses, this.finallyProcessor);
    }

    protected void handleException(Exchange exchange, Throwable e) throws Throwable {
        for (CatchProcessor catchClause : this.catchClauses) {
            if (!catchClause.catches(e)) continue;
            exchange.setException(e);
            try {
                catchClause.process(exchange);
            }
            catch (Exception e1) {
                LOG.warn("Caught exception inside catch clause: " + e1, e1);
                throw e1;
            }
            return;
        }
        if (this.finallyProcessor == null) {
            throw e;
        }
    }
}

