/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.impl.converter.AsyncProcessorTypeConverter;
import org.apache.camel.processor.MulticastProcessor;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.ExchangeHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pipeline
extends MulticastProcessor
implements AsyncProcessor {
    private static final transient Log LOG = LogFactory.getLog(Pipeline.class);

    public Pipeline(Collection<Processor> processors) {
        super(processors);
    }

    public static Processor newInstance(List<Processor> processors) {
        if (processors.isEmpty()) {
            return null;
        }
        if (processors.size() == 1) {
            return processors.get(0);
        }
        return new Pipeline(processors);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    @Override
    public boolean process(Exchange original, AsyncCallback callback) {
        Exchange nextExchange;
        block4: {
            AsyncProcessor processor;
            boolean sync;
            Iterator<Processor> processors = this.getProcessors().iterator();
            nextExchange = original;
            boolean first = true;
            do {
                if (nextExchange.isFailed()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Mesage exchange has failed so breaking out of pipeline: " + nextExchange + " exception: " + nextExchange.getException() + " fault: " + nextExchange.getFault(false));
                    }
                    break block4;
                }
                if (!processors.hasNext()) break block4;
                processor = AsyncProcessorTypeConverter.convert(processors.next());
                if (first) {
                    first = false;
                    continue;
                }
                nextExchange = this.createNextExchange(processor, nextExchange);
            } while (sync = this.process(original, nextExchange, callback, processors, processor));
            return false;
        }
        ExchangeHelper.copyResults(original, nextExchange);
        callback.done(true);
        return true;
    }

    private boolean process(final Exchange original, final Exchange exchange, final AsyncCallback callback, final Iterator<Processor> processors, AsyncProcessor processor) {
        return processor.process(exchange, new AsyncCallback(){

            public void done(boolean sync) {
                if (sync) {
                    return;
                }
                Exchange nextExchange = exchange;
                while (processors.hasNext()) {
                    AsyncProcessor processor = AsyncProcessorTypeConverter.convert((Processor)processors.next());
                    if (nextExchange.isFailed()) {
                        if (!LOG.isDebugEnabled()) break;
                        LOG.debug("Mesage exchange has failed so breaking out of pipeline: " + nextExchange + " exception: " + nextExchange.getException() + " fault: " + nextExchange.getFault(false));
                        break;
                    }
                    nextExchange = Pipeline.this.createNextExchange(processor, exchange);
                    sync = Pipeline.this.process(original, nextExchange, callback, processors, processor);
                    if (sync) continue;
                    return;
                }
                ExchangeHelper.copyResults(original, nextExchange);
                callback.done(false);
            }
        });
    }

    protected Exchange createNextExchange(Processor producer, Exchange previousExchange) {
        Exchange answer = this.copyExchangeStrategy(previousExchange);
        Message previousOut = previousExchange.getOut(false);
        Object output = previousOut != null ? previousOut.getBody() : null;
        Message in = answer.getIn();
        if (output != null) {
            in.setBody(output);
            Set<Map.Entry<String, Object>> entries = previousOut.getHeaders().entrySet();
            for (Map.Entry<String, Object> entry : entries) {
                in.setHeader(entry.getKey(), entry.getValue());
            }
        } else {
            Object previousInBody = previousExchange.getIn().getBody();
            if (in.getBody() == null && previousInBody != null) {
                LOG.warn("Bad exchange implementation; the copy() method did not copy across the in body: " + previousExchange + " of type: " + previousExchange.getClass());
                in.setBody(previousInBody);
            }
        }
        return answer;
    }

    protected Exchange copyExchangeStrategy(Exchange exchange) {
        return exchange.copy();
    }

    @Override
    public String toString() {
        return "Pipeline" + this.getProcessors();
    }
}

