/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.processor.LoggingLevel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Logger
implements Processor {
    private Log log;
    private LoggingLevel level;

    public Logger() {
        this(LogFactory.getLog(Logger.class));
    }

    public Logger(Log log) {
        this(log, LoggingLevel.INFO);
    }

    public Logger(Log log, LoggingLevel level) {
        this.log = log;
        this.level = level;
    }

    public Logger(String logName) {
        this(LogFactory.getLog(logName));
    }

    public Logger(String logName, LoggingLevel level) {
        this(LogFactory.getLog(logName), level);
    }

    public String toString() {
        return "Logger[" + this.log + "]";
    }

    public void process(Exchange exchange) {
        switch (this.level) {
            case DEBUG: {
                if (!this.log.isDebugEnabled()) break;
                this.log.debug(this.logMessage(exchange));
                break;
            }
            case ERROR: {
                if (!this.log.isErrorEnabled()) break;
                this.log.error(this.logMessage(exchange));
                break;
            }
            case FATAL: {
                if (!this.log.isFatalEnabled()) break;
                this.log.fatal(this.logMessage(exchange));
                break;
            }
            case INFO: {
                if (!this.log.isInfoEnabled()) break;
                this.log.info(this.logMessage(exchange));
                break;
            }
            case TRACE: {
                if (!this.log.isTraceEnabled()) break;
                this.log.trace(this.logMessage(exchange));
                break;
            }
            case WARN: {
                if (!this.log.isWarnEnabled()) break;
                this.log.warn(this.logMessage(exchange));
                break;
            }
            default: {
                this.log.error("Unknown level: " + (Object)((Object)this.level) + " when trying to log exchange: " + this.logMessage(exchange));
            }
        }
    }

    public void log(String message) {
        switch (this.level) {
            case DEBUG: {
                if (!this.log.isDebugEnabled()) break;
                this.log.debug(message);
                break;
            }
            case ERROR: {
                if (!this.log.isErrorEnabled()) break;
                this.log.error(message);
                break;
            }
            case FATAL: {
                if (!this.log.isFatalEnabled()) break;
                this.log.fatal(message);
                break;
            }
            case INFO: {
                if (!this.log.isInfoEnabled()) break;
                this.log.debug(message);
                break;
            }
            case TRACE: {
                if (!this.log.isTraceEnabled()) break;
                this.log.trace(message);
                break;
            }
            case WARN: {
                if (!this.log.isWarnEnabled()) break;
                this.log.warn(message);
                break;
            }
            default: {
                this.log.error("Unknown level: " + (Object)((Object)this.level) + " when trying to log exchange: " + message);
            }
        }
    }

    public void log(String message, Throwable exception) {
        switch (this.level) {
            case DEBUG: {
                if (!this.log.isDebugEnabled()) break;
                this.log.debug(message, exception);
                break;
            }
            case ERROR: {
                if (!this.log.isErrorEnabled()) break;
                this.log.error(message, exception);
                break;
            }
            case FATAL: {
                if (!this.log.isFatalEnabled()) break;
                this.log.fatal(message, exception);
                break;
            }
            case INFO: {
                if (!this.log.isInfoEnabled()) break;
                this.log.debug(message, exception);
                break;
            }
            case TRACE: {
                if (!this.log.isTraceEnabled()) break;
                this.log.trace(message, exception);
                break;
            }
            case WARN: {
                if (!this.log.isWarnEnabled()) break;
                this.log.warn(message, exception);
                break;
            }
            default: {
                this.log.error("Unknown level: " + (Object)((Object)this.level) + " when trying to log exchange: " + message, exception);
            }
        }
    }

    protected Object logMessage(Exchange exchange) {
        return exchange;
    }

    public Log getLog() {
        return this.log;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public LoggingLevel getLevel() {
        return this.level;
    }

    public void setLevel(LoggingLevel level) {
        this.level = level;
    }
}

