/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.language;

import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.impl.RouteContext;
import org.apache.camel.spi.Language;
import org.apache.camel.util.CollectionStringBuffer;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlType(name="expressionType")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ExpressionType {
    @XmlAttribute
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlID
    private String id;
    @XmlValue
    private String expression;
    @XmlTransient
    private Predicate predicate;
    @XmlTransient
    private Expression expressionValue;

    public static String getLabel(List<ExpressionType> expressions) {
        CollectionStringBuffer buffer = new CollectionStringBuffer();
        for (ExpressionType expression : expressions) {
            buffer.append(expression.getLabel());
        }
        return buffer.toString();
    }

    public ExpressionType() {
    }

    public ExpressionType(String expression) {
        this.expression = expression;
    }

    public ExpressionType(Predicate predicate) {
        this.predicate = predicate;
    }

    public ExpressionType(Expression expression) {
        this.expressionValue = expression;
    }

    public String toString() {
        return this.getLanguage() + "Expression[" + this.getExpression() + "]";
    }

    public String getLanguage() {
        return "";
    }

    public Predicate<Exchange> createPredicate(RouteContext route) {
        if (this.predicate == null) {
            CamelContext camelContext = route.getCamelContext();
            Language language = camelContext.resolveLanguage(this.getLanguage());
            this.predicate = language.createPredicate(this.getExpression());
        }
        return this.predicate;
    }

    public Expression createExpression(RouteContext routeContext) {
        if (this.expressionValue == null) {
            CamelContext camelContext = routeContext.getCamelContext();
            Language language = camelContext.resolveLanguage(this.getLanguage());
            this.expressionValue = language.createExpression(this.getExpression());
        }
        return this.expressionValue;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    public Expression getExpressionValue() {
        return this.expressionValue;
    }

    public String getLabel() {
        String language = this.getExpression();
        if (ObjectHelper.isNullOrBlank(language)) {
            Predicate predicate = this.getPredicate();
            if (predicate != null) {
                return predicate.toString();
            }
            Expression expressionValue = this.getExpressionValue();
            if (expressionValue != null) {
                return expressionValue.toString();
            }
        } else {
            return language;
        }
        return "";
    }
}

