/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.model.dataformat.ArtixDSContentType;
import org.apache.camel.model.dataformat.DataFormatType;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="artixDS")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ArtixDSDataFormat
extends DataFormatType {
    @XmlAttribute(required=false)
    private String elementTypeName;
    @XmlAttribute(required=false)
    private String format;
    @XmlAttribute(required=false)
    private Class<?> elementType;
    @XmlAttribute(required=false)
    private ArtixDSContentType contentType;

    public ArtixDSDataFormat() {
        super("org.apache.camel.artix.ds.ArtixDSFormat");
    }

    public ArtixDSDataFormat(Class<?> elementType) {
        this();
        this.elementType = elementType;
    }

    public ArtixDSDataFormat(Class<?> elementType, ArtixDSContentType contentType) {
        this();
        this.elementType = elementType;
        this.contentType = contentType;
    }

    public ArtixDSDataFormat(ArtixDSContentType contentType) {
        this();
        this.contentType = contentType;
    }

    public String getElementTypeName() {
        return this.elementTypeName;
    }

    public void setElementTypeName(String elementTypeName) {
        this.elementTypeName = elementTypeName;
    }

    public ArtixDSContentType getContentType() {
        return this.contentType;
    }

    public void setContentType(ArtixDSContentType contentType) {
        this.contentType = contentType;
    }

    public Class<?> getElementType() {
        if (this.elementType == null && this.elementTypeName != null) {
            this.elementType = ObjectHelper.loadClass(this.elementTypeName, this.getClass().getClassLoader());
        }
        return this.elementType;
    }

    public void setElementType(Class<?> elementType) {
        this.elementType = elementType;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    protected void configureDataFormat(DataFormat dataFormat) {
        ArtixDSContentType content;
        Class<?> type = this.getElementType();
        if (type != null) {
            this.setProperty(dataFormat, "elementType", type);
        }
        if ((content = this.getContentType()) != null) {
            this.setProperty(dataFormat, "contentType", (Object)content);
        }
    }
}

