/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Predicate;
import org.apache.camel.Route;
import org.apache.camel.model.ExceptionType;
import org.apache.camel.model.InterceptType;
import org.apache.camel.model.InterceptorRef;
import org.apache.camel.model.InterceptorType;
import org.apache.camel.model.OtherwiseType;
import org.apache.camel.model.RouteContainer;
import org.apache.camel.model.RouteType;
import org.apache.camel.model.ServiceActivationType;
import org.apache.camel.processor.DelegateProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="routes")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RoutesType
implements RouteContainer {
    @XmlAttribute
    private Boolean inheritErrorHandlerFlag = Boolean.TRUE;
    @XmlElementRef
    private List<RouteType> routes = new ArrayList<RouteType>();
    @XmlElementRef
    private List<ServiceActivationType> activations = new ArrayList<ServiceActivationType>();
    @XmlTransient
    private List<InterceptorType> interceptors = new ArrayList<InterceptorType>();
    @XmlTransient
    private List<InterceptType> intercepts = new ArrayList<InterceptType>();
    @XmlTransient
    private List<ExceptionType> exceptions = new ArrayList<ExceptionType>();
    @XmlTransient
    private CamelContext camelContext;

    public String toString() {
        return "Routes: " + this.routes;
    }

    public void populateRoutes(List<Route> answer) throws Exception {
        for (RouteType route : this.routes) {
            route.addRoutes(this.camelContext, answer);
        }
    }

    @Override
    public List<RouteType> getRoutes() {
        return this.routes;
    }

    @Override
    public void setRoutes(List<RouteType> routes) {
        this.routes = routes;
    }

    public List<InterceptorType> getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(List<InterceptorType> interceptors) {
        this.interceptors = interceptors;
    }

    public List<InterceptType> getIntercepts() {
        return this.intercepts;
    }

    public void setIntercepts(List<InterceptType> intercepts) {
        this.intercepts = intercepts;
    }

    public List<ExceptionType> getExceptions() {
        return this.exceptions;
    }

    public void setExceptions(List<ExceptionType> exceptions) {
        this.exceptions = exceptions;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public Boolean getInheritErrorHandlerFlag() {
        return this.inheritErrorHandlerFlag;
    }

    public void setInheritErrorHandlerFlag(Boolean inheritErrorHandlerFlag) {
        this.inheritErrorHandlerFlag = inheritErrorHandlerFlag;
    }

    public RouteType route() {
        RouteType route = this.createRoute();
        return this.route(route);
    }

    public RouteType from(String uri) {
        RouteType route = this.createRoute();
        route.from(uri);
        return this.route(route);
    }

    public RouteType from(Endpoint endpoint) {
        RouteType route = this.createRoute();
        route.from(endpoint);
        return this.route(route);
    }

    public RouteType route(RouteType route) {
        route.setCamelContext(this.getCamelContext());
        route.setInheritErrorHandlerFlag(this.getInheritErrorHandlerFlag());
        route.getInterceptors().addAll(this.getInterceptors());
        route.getOutputs().addAll(this.getIntercepts());
        route.getOutputs().addAll(this.getExceptions());
        this.getRoutes().add(route);
        return route;
    }

    public RoutesType intercept(DelegateProcessor interceptor) {
        this.getInterceptors().add(new InterceptorRef(interceptor));
        return this;
    }

    public InterceptType intercept() {
        InterceptType answer = new InterceptType();
        this.getIntercepts().add(answer);
        return answer;
    }

    public OtherwiseType intercept(Predicate predicate) {
        InterceptType answer = new InterceptType();
        this.getIntercepts().add(answer);
        return answer.when(predicate);
    }

    public ExceptionType exception(Class exceptionType) {
        ExceptionType answer = new ExceptionType(exceptionType);
        this.getExceptions().add(answer);
        return answer;
    }

    protected RouteType createRoute() {
        return new RouteType();
    }
}

