/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.Service;
import org.apache.camel.impl.RouteContext;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.language.ExpressionType;
import org.apache.camel.processor.Aggregator;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.aggregate.UseLatestAggregationStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="aggregator")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AggregatorType
extends ExpressionNode {
    @XmlTransient
    private AggregationStrategy aggregationStrategy = new UseLatestAggregationStrategy();
    private int batchSize;
    private long batchTimeout;

    public AggregatorType() {
    }

    public AggregatorType(Expression correlationExpression) {
        super(correlationExpression);
    }

    public AggregatorType(ExpressionType correlationExpression) {
        super(correlationExpression);
    }

    public AggregatorType(Expression correlationExpression, AggregationStrategy aggregationStrategy) {
        super(correlationExpression);
        this.aggregationStrategy = aggregationStrategy;
    }

    public String toString() {
        return "Aggregator[ " + this.getExpression() + " -> " + this.getOutputs() + "]";
    }

    @Override
    public void addRoutes(RouteContext routeContext, Collection<Route> routes) throws Exception {
        Endpoint from = routeContext.getEndpoint();
        final Processor processor = routeContext.createProcessor(this);
        Aggregator service = new Aggregator(from, processor, this.getExpression().createExpression(routeContext), this.aggregationStrategy);
        if (this.batchSize != 0) {
            service.setBatchSize(this.batchSize);
        }
        if (this.batchSize != 0) {
            service.setBatchTimeout(this.batchTimeout);
        }
        Route<Exchange> route = new Route<Exchange>(from, new Service[]{service}){

            @Override
            public String toString() {
                return "AggregatorRoute[" + this.getEndpoint() + " -> " + processor + "]";
            }
        };
        routes.add(route);
    }

    public AggregationStrategy getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    public void setAggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategy = aggregationStrategy;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public long getBatchTimeout() {
        return this.batchTimeout;
    }

    public void setBatchTimeout(long batchTimeout) {
        this.batchTimeout = batchTimeout;
    }

    public AggregatorType batchSize(int batchSize) {
        this.setBatchSize(batchSize);
        return this;
    }

    public AggregatorType batchTimeout(long batchTimeout) {
        this.setBatchTimeout(batchTimeout);
        return this;
    }
}

