/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.management.Counter;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource(description="PerformanceCounter", currencyTimeLimit=15)
public class PerformanceCounter
extends Counter {
    private AtomicLong numCompleted = new AtomicLong(0L);
    private long minProcessingTime = -1L;
    private long maxProcessingTime = -1L;
    private double totalProcessingTime = 0.0;

    @ManagedOperation(description="Reset counters")
    public synchronized void reset() {
        super.reset();
        this.numCompleted.set(0L);
        this.minProcessingTime = 0L;
        this.maxProcessingTime = 0L;
        this.totalProcessingTime = 0.0;
    }

    @ManagedAttribute(description="Number of successful exchanges")
    public long getNumCompleted() throws Exception {
        return this.numCompleted.get();
    }

    @ManagedAttribute(description="Number of failed exchanges")
    public long getNumFailed() throws Exception {
        return this.numExchanges.get() - this.numCompleted.get();
    }

    @ManagedAttribute(description="Min Processing Time [usec]")
    public synchronized long getMinProcessingTime() throws Exception {
        return this.minProcessingTime;
    }

    @ManagedAttribute(description="Mean Processing Time [usec]")
    public synchronized long getMeanProcessingTime() throws Exception {
        long count = this.numCompleted.get();
        return count > 0L ? (long)this.totalProcessingTime / count : 0L;
    }

    @ManagedAttribute(description="Max Processing Time [usec]")
    public synchronized long getMaxProcessingTime() throws Exception {
        return this.maxProcessingTime;
    }

    public synchronized void completedExchange(long time) {
        this.increment();
        this.numCompleted.incrementAndGet();
        this.totalProcessingTime += (double)time;
        if (this.minProcessingTime < 0L || time < this.minProcessingTime) {
            this.minProcessingTime = time;
        }
        if (time > this.maxProcessingTime) {
            this.maxProcessingTime = time;
        }
    }

    public void completedExchange() {
        this.numExchanges.incrementAndGet();
    }
}

