/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.management.ManagedEndpoint;
import org.apache.camel.management.ManagedRoute;
import org.apache.camel.management.ManagedService;
import org.apache.camel.management.PerformanceCounter;

public class CamelNamingStrategy {
    public static final String VALUE_UNKNOWN = "unknown";
    public static final String VALUE_ROUTE = "route";
    public static final String KEY_NAME = "name";
    public static final String KEY_TYPE = "type";
    public static final String KEY_CONTEXT = "context";
    public static final String KEY_GROUP = "group";
    public static final String KEY_COMPONENT = "component";
    public static final String KEY_ROUTE_TYPE = "routeType";
    public static final String KEY_ROUTE = "route";
    public static final String GROUP_ENDPOINTS = "endpoints";
    public static final String GROUP_SERVICES = "services";
    public static final String GROUP_ROUTE_BUILDER = "routeBuilder";
    public static final String GROUP_ROUTE_TYPE = "routeType";
    protected String domainName;
    protected String hostName = "locahost";

    public CamelNamingStrategy() {
        this("org.apache.camel");
    }

    public CamelNamingStrategy(String domainName) {
        if (domainName != null) {
            this.domainName = domainName;
        }
        try {
            this.hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public ObjectName getObjectName(CamelContext context) throws MalformedObjectNameException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.domainName + ":");
        buffer.append("context=" + this.getContextId(context) + ",");
        buffer.append("name=context");
        return this.createObjectName(buffer);
    }

    public ObjectName getObjectName(ManagedEndpoint mbean) throws MalformedObjectNameException {
        Endpoint ep = mbean.getEndpoint();
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.domainName + ":");
        buffer.append("context=" + this.getContextId(ep.getContext()) + ",");
        buffer.append("group=endpoints,");
        buffer.append("component=" + this.getComponentId(ep) + ",");
        buffer.append("name=" + this.getEndpointId(ep));
        return this.createObjectName(buffer);
    }

    public ObjectName getObjectName(CamelContext context, ManagedService mbean) throws MalformedObjectNameException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.domainName + ":");
        buffer.append("context=" + this.getContextId(context) + ",");
        buffer.append("group=services,");
        buffer.append("name=" + Integer.toHexString(mbean.getService().hashCode()));
        return this.createObjectName(buffer);
    }

    public ObjectName getObjectName(ManagedRoute mbean) throws MalformedObjectNameException {
        Endpoint ep = mbean.getRoute().getEndpoint();
        String ctxid = ep != null ? this.getContextId(ep.getContext()) : VALUE_UNKNOWN;
        String cid = this.getComponentId(ep);
        String id = VALUE_UNKNOWN.equals(cid) ? this.getEndpointId(ep) : "[" + cid + "]" + this.getEndpointId(ep);
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.domainName + ":");
        buffer.append("context=" + ctxid + ",");
        buffer.append("group=routeBuilder,");
        buffer.append("routeType=routeType,");
        buffer.append("route=" + id + ",");
        buffer.append("name=route");
        return this.createObjectName(buffer);
    }

    public ObjectName getObjectName(CamelContext context, PerformanceCounter mbean) throws MalformedObjectNameException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.domainName + ":");
        buffer.append("context=" + this.getContextId(context) + ",");
        buffer.append("group=endpoints,");
        buffer.append("route=Route.Counter,");
        buffer.append("name=Stats");
        return this.createObjectName(buffer);
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    protected String getContextId(CamelContext context) {
        String id = context != null ? context.getName() : VALUE_UNKNOWN;
        return this.hostName + "/" + id;
    }

    protected String getComponentId(Endpoint ep) {
        String uri = ep.getEndpointUri();
        int pos = uri.indexOf(58);
        return pos == -1 ? VALUE_UNKNOWN : uri.substring(0, pos);
    }

    protected String getEndpointId(Endpoint ep) {
        String id;
        String uri = ep.getEndpointUri();
        int pos = uri.indexOf(58);
        String string = id = pos == -1 ? uri : uri.substring(pos + 1);
        if (!ep.isSingleton()) {
            id = id + "." + Integer.toString(ep.hashCode());
        }
        id = id.replace("=", "_eq_");
        id = id.replace(",", "_cm_");
        return id;
    }

    protected ObjectName createObjectName(StringBuffer buffer) throws MalformedObjectNameException {
        String text = buffer.toString();
        try {
            text = text.replace("?", "_qe_");
            return new ObjectName(text);
        }
        catch (MalformedObjectNameException e) {
            throw new MalformedObjectNameException("Could not create ObjectName from: " + text + ". Reason: " + e);
        }
    }
}

