/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.Registry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JndiRegistry
implements Registry {
    private Context context;

    public JndiRegistry() {
    }

    public JndiRegistry(Context context) {
        this.context = context;
    }

    @Override
    public <T> T lookup(String name, Class<T> type) {
        Object value = this.lookup(name);
        return type.cast(value);
    }

    @Override
    public Object lookup(String name) {
        try {
            return this.getContext().lookup(name);
        }
        catch (NameNotFoundException e) {
            return null;
        }
        catch (NamingException e) {
            throw new RuntimeCamelException(e);
        }
    }

    public void bind(String s, Object o) {
        try {
            this.getContext().bind(s, o);
        }
        catch (NamingException e) {
            throw new RuntimeCamelException(e);
        }
    }

    public void close() throws NamingException {
        this.getContext().close();
    }

    public Context getContext() throws NamingException {
        if (this.context == null) {
            this.context = this.createContext();
        }
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    protected Context createContext() throws NamingException {
        Hashtable<Object, Object> properties = new Hashtable<Object, Object>(System.getProperties());
        return new InitialContext(properties);
    }
}

