/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.net.URI;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.impl.ScheduledPollEndpoint;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.UnsafeUriCharactersEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultComponent<E extends Exchange>
extends ServiceSupport
implements Component<E> {
    private int defaultThreadPoolSize = 5;
    private CamelContext camelContext;
    private ScheduledExecutorService executorService;

    public DefaultComponent() {
    }

    public DefaultComponent(CamelContext context) {
        this.camelContext = context;
    }

    @Override
    public Endpoint<E> createEndpoint(String uri) throws Exception {
        Map parameters;
        Endpoint<E> endpoint;
        int idx;
        ObjectHelper.notNull(this.getCamelContext(), "camelContext");
        URI u = new URI(UnsafeUriCharactersEncoder.encode(uri));
        String path = u.getSchemeSpecificPart();
        if (path.startsWith("//")) {
            path = path.substring(2);
        }
        if ((idx = path.indexOf(63)) > 0) {
            path = path.substring(0, idx);
        }
        if ((endpoint = this.createEndpoint(uri, path, parameters = URISupport.parseParamters(u))) == null) {
            return null;
        }
        if (parameters != null) {
            if (endpoint instanceof ScheduledPollEndpoint) {
                ScheduledPollEndpoint scheduledPollEndpoint = (ScheduledPollEndpoint)endpoint;
                scheduledPollEndpoint.configureProperties(parameters);
            }
            this.setProperties(endpoint, parameters);
        }
        return endpoint;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext context) {
        this.camelContext = context;
    }

    public ScheduledExecutorService getExecutorService() {
        if (this.executorService == null) {
            this.executorService = this.createExecutorService();
        }
        return this.executorService;
    }

    public void setExecutorService(ScheduledExecutorService executorService) {
        this.executorService = executorService;
    }

    protected ScheduledExecutorService createExecutorService() {
        return new ScheduledThreadPoolExecutor(this.defaultThreadPoolSize, new ThreadFactory(){
            int counter;

            public synchronized Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable);
                thread.setName("Thread: " + ++this.counter + " " + DefaultComponent.this.toString());
                return thread;
            }
        });
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }

    protected abstract Endpoint<E> createEndpoint(String var1, String var2, Map var3) throws Exception;

    protected void setProperties(Object bean, Map parameters) throws Exception {
        IntrospectionSupport.setProperties(this.getCamelContext().getTypeConverter(), bean, parameters);
    }
}

