/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mina;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.mina.MinaEndpoint;
import org.apache.camel.component.mina.MinaExchange;
import org.apache.camel.impl.DefaultComponent;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoConnector;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.support.BaseIoConnectorConfig;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.serialization.ObjectSerializationCodecFactory;
import org.apache.mina.filter.codec.textline.TextLineCodecFactory;
import org.apache.mina.transport.socket.nio.DatagramAcceptor;
import org.apache.mina.transport.socket.nio.DatagramConnector;
import org.apache.mina.transport.socket.nio.DatagramConnectorConfig;
import org.apache.mina.transport.socket.nio.SocketAcceptor;
import org.apache.mina.transport.socket.nio.SocketConnector;
import org.apache.mina.transport.socket.nio.SocketConnectorConfig;
import org.apache.mina.transport.vmpipe.VmPipeAcceptor;
import org.apache.mina.transport.vmpipe.VmPipeAddress;
import org.apache.mina.transport.vmpipe.VmPipeConnector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinaComponent
extends DefaultComponent<MinaExchange> {
    public MinaComponent() {
    }

    public MinaComponent(CamelContext context) {
        super(context);
    }

    @Override
    protected Endpoint<MinaExchange> createEndpoint(String uri, String remaining, Map parameters) throws Exception {
        URI u = new URI(remaining);
        String protocol = u.getScheme();
        if (protocol.equals("tcp")) {
            return this.createSocketEndpoint(uri, u, parameters);
        }
        if (protocol.equals("udp") || protocol.equals("mcast") || protocol.equals("multicast")) {
            return this.createDatagramEndpoint(uri, u, parameters);
        }
        if (protocol.equals("vm")) {
            return this.createVmEndpoint(uri, u);
        }
        throw new IOException("Unrecognised MINA protocol: " + protocol + " for uri: " + uri);
    }

    protected MinaEndpoint createVmEndpoint(String uri, URI connectUri) {
        VmPipeAcceptor acceptor = new VmPipeAcceptor();
        VmPipeAddress address = new VmPipeAddress(connectUri.getPort());
        VmPipeConnector connector = new VmPipeConnector();
        return new MinaEndpoint(uri, this, (SocketAddress)address, (IoAcceptor)acceptor, (IoConnector)connector, null);
    }

    protected MinaEndpoint createSocketEndpoint(String uri, URI connectUri, Map parameters) {
        SocketAcceptor acceptor = new SocketAcceptor();
        InetSocketAddress address = new InetSocketAddress(connectUri.getHost(), connectUri.getPort());
        SocketConnector connector = new SocketConnector();
        SocketConnectorConfig config = new SocketConnectorConfig();
        this.configureCodecFactory((BaseIoConnectorConfig)config, parameters);
        return new MinaEndpoint(uri, this, address, (IoAcceptor)acceptor, (IoConnector)connector, (IoServiceConfig)config);
    }

    protected MinaEndpoint createDatagramEndpoint(String uri, URI connectUri, Map parameters) {
        DatagramAcceptor acceptor = new DatagramAcceptor();
        InetSocketAddress address = new InetSocketAddress(connectUri.getHost(), connectUri.getPort());
        DatagramConnector connector = new DatagramConnector();
        DatagramConnectorConfig config = new DatagramConnectorConfig();
        this.configureCodecFactory((BaseIoConnectorConfig)config, parameters);
        return new MinaEndpoint(uri, this, address, (IoAcceptor)acceptor, (IoConnector)connector, (IoServiceConfig)config);
    }

    protected void configureCodecFactory(BaseIoConnectorConfig config, Map parameters) {
        boolean textline = false;
        if (parameters != null) {
            if (parameters.containsKey("codec")) {
                String value = (String)parameters.get("codec");
                if (value.equals("textline")) {
                    textline = true;
                }
            } else {
                textline = false;
            }
        }
        if (textline) {
            config.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new TextLineCodecFactory()));
        } else {
            config.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new ObjectSerializationCodecFactory()));
        }
    }
}

