/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.log;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.impl.ProcessorEndpoint;
import org.apache.camel.processor.Logger;
import org.apache.camel.processor.LoggingLevel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogComponent
extends DefaultComponent<Exchange> {
    private static final Log LOG = LogFactory.getLog(LogComponent.class);

    @Override
    protected Endpoint<Exchange> createEndpoint(String uri, String remaining, Map parameters) throws Exception {
        LoggingLevel level = this.getLoggingLevel(parameters);
        Logger logger = new Logger(remaining, level);
        return new ProcessorEndpoint(uri, this, (Processor)logger);
    }

    protected LoggingLevel getLoggingLevel(Map parameters) {
        String levelText = (String)parameters.get("level");
        LoggingLevel level = null;
        if (levelText != null && (level = LoggingLevel.valueOf(levelText.toUpperCase())) == null) {
            LOG.warn("Could not convert level text: " + levelText + " to a valid logging level so defaulting to WARN");
        }
        if (level == null) {
            level = LoggingLevel.INFO;
        }
        return level;
    }
}

