/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jmx;

import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.management.monitor.CounterMonitor;
import org.apache.camel.Consumer;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.jmx.JMXComponent;
import org.apache.camel.component.jmx.JMXConsumer;
import org.apache.camel.component.jmx.JMXExchange;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMXEndpoint
extends DefaultEndpoint<JMXExchange> {
    private static final Log LOG = LogFactory.getLog(JMXEndpoint.class);
    private String name;
    private ObjectName ourName;
    private String observedObjectName;
    private String attributeName;
    private long granularityPeriod = 5000L;
    private Number threshold;
    private Number offset;
    private MBeanServer mbeanServer;
    private CounterMonitor counterMonitor = new CounterMonitor();

    protected JMXEndpoint(String endpointUri, JMXComponent component) {
        super(endpointUri, component);
        this.observedObjectName = endpointUri;
    }

    @Override
    public Producer<JMXExchange> createProducer() throws Exception {
        throw new RuntimeException("Not supported");
    }

    @Override
    public Consumer<JMXExchange> createConsumer(Processor proc) throws Exception {
        ObjectName observedName = new ObjectName(this.observedObjectName);
        if (this.name == null) {
            String type = observedName.getKeyProperty("type");
            type = type != null ? type : "UNKNOWN";
            this.name = this.mbeanServer.getDefaultDomain() + ":type=CounterMonitor_" + type;
        }
        JMXConsumer result = new JMXConsumer(this, proc);
        this.ourName = new ObjectName(this.name);
        this.counterMonitor.setNotify(true);
        this.counterMonitor.addObservedObject(observedName);
        this.counterMonitor.setObservedAttribute(this.attributeName);
        this.counterMonitor.setGranularityPeriod(this.granularityPeriod);
        this.counterMonitor.setDifferenceMode(false);
        this.counterMonitor.setInitThreshold(this.threshold);
        this.counterMonitor.setOffset(this.offset);
        this.mbeanServer.registerMBean(this.counterMonitor, this.ourName);
        this.mbeanServer.addNotificationListener(this.ourName, result, null, new Object());
        return result;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    public JMXExchange createExchange(Notification notification) {
        return new JMXExchange(this.getContext(), this.getExchangePattern(), notification);
    }

    @Override
    public JMXExchange createExchange() {
        return new JMXExchange(this.getContext(), this.getExchangePattern(), null);
    }

    @Override
    public JMXExchange createExchange(ExchangePattern pattern) {
        return new JMXExchange(this.getContext(), pattern, null);
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public long getGranularityPeriod() {
        return this.granularityPeriod;
    }

    public void setGranularityPeriod(long granularityPeriod) {
        this.granularityPeriod = granularityPeriod;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Number getOffset() {
        return this.offset;
    }

    public void setOffset(Number offset) {
        this.offset = offset;
    }

    public Number getThreshold() {
        return this.threshold;
    }

    public void setThreshold(Number threshold) {
        this.threshold = threshold;
    }

    public MBeanServer getMbeanServer() {
        return this.mbeanServer;
    }

    public void setMbeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }
}

