/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ibatis;

import com.ibatis.sqlmap.client.SqlMapClient;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.ibatis.IBatisEndpoint;
import org.apache.camel.impl.PollingConsumerSupport;

public class IBatisPollingConsumer
extends PollingConsumerSupport {
    private final IBatisEndpoint endpoint;
    private SqlMapClient sqlClient;
    private String queryName;

    public IBatisPollingConsumer(IBatisEndpoint endpoint) {
        super(endpoint);
        this.endpoint = endpoint;
        this.queryName = endpoint.getEntityName();
    }

    public Exchange receive(long timeout) {
        return this.receiveNoWait();
    }

    public Exchange receive() {
        return this.receiveNoWait();
    }

    public Exchange receiveNoWait() {
        try {
            if (this.sqlClient == null) {
                this.sqlClient = this.endpoint.getSqlClient();
            }
            List list = this.sqlClient.queryForList(this.queryName);
            Object exchange = this.endpoint.createExchange();
            Message in = exchange.getIn();
            in.setBody(list);
            in.setHeader("org.apache.camel.ibatis.queryName", this.queryName);
            return exchange;
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Failed to poll: " + this.endpoint + ". Reason: " + e, e);
        }
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }
}

