/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import java.io.IOException;
import java.io.InputStream;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.file.remote.FtpEndpoint;
import org.apache.camel.component.file.remote.RemoteFileExchange;
import org.apache.camel.component.file.remote.RemoteFileProducer;
import org.apache.commons.net.ftp.FTPClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtpProducer
extends RemoteFileProducer<RemoteFileExchange> {
    FtpEndpoint endpoint;
    private final FTPClient client;

    public FtpProducer(FtpEndpoint endpoint, FTPClient client) {
        super(endpoint);
        this.endpoint = endpoint;
        this.client = client;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        this.process((RemoteFileExchange)this.endpoint.createExchange(exchange));
    }

    public void process(RemoteFileExchange exchange) throws Exception {
        InputStream payload = exchange.getIn().getBody(InputStream.class);
        String endpointFile = this.endpoint.getConfiguration().getFile();
        this.client.changeWorkingDirectory(endpointFile);
        String fileName = this.createFileName(exchange.getIn(), this.endpoint.getConfiguration());
        FtpProducer.buildDirectory(this.client, fileName.substring(0, fileName.lastIndexOf(47)));
        boolean success = this.client.storeFile(fileName, payload);
        if (!success) {
            throw new RuntimeCamelException("error sending file");
        }
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        this.client.disconnect();
        super.doStop();
    }

    protected static boolean buildDirectory(FTPClient ftpClient, String dirName) throws IOException {
        String[] dirs;
        boolean atLeastOneSuccess = false;
        StringBuilder sb = new StringBuilder(dirName.length());
        for (String dir : dirs = dirName.split("\\/")) {
            sb.append('/').append(dir);
            boolean success = ftpClient.makeDirectory(sb.toString());
            System.out.println(sb.toString() + " = " + success);
            if (atLeastOneSuccess || !success) continue;
            atLeastOneSuccess = true;
        }
        return atLeastOneSuccess;
    }
}

