/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.transport;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.cxf.transport.CamelTransportBase;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.Configurable;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractConduit;
import org.apache.cxf.transport.AbstractDestination;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.wsdl.EndpointReferenceUtils;

public class CamelDestination
extends AbstractDestination
implements Configurable {
    protected static final String BASE_BEAN_NAME_SUFFIX = ".camel-destination-base";
    private static final Logger LOG = LogUtils.getL7dLogger(CamelDestination.class);
    CamelContext camelContext;
    String camelUri;
    final ConduitInitiator conduitInitiator;
    private CamelTransportBase base;
    private Endpoint endpoint;

    public CamelDestination(CamelContext camelContext, Bus bus, ConduitInitiator ci, EndpointInfo info) throws IOException {
        super(CamelDestination.getTargetReference((EndpointInfo)info, (Bus)bus), info);
        this.camelContext = camelContext;
        this.base = new CamelTransportBase(camelContext, bus, this.endpointInfo, true, BASE_BEAN_NAME_SUFFIX);
        this.conduitInitiator = ci;
        this.initConfig();
    }

    protected Logger getLogger() {
        return LOG;
    }

    protected Conduit getInbuiltBackChannel(Message inMessage) {
        return new BackChannelConduit(EndpointReferenceUtils.getAnonymousEndpointReference(), inMessage);
    }

    public void activate() {
        this.getLogger().log(Level.INFO, "CamelDestination activate().... ");
        try {
            this.getLogger().log(Level.FINE, "establishing Camel connection");
            this.endpoint = this.camelContext.getEndpoint(this.camelUri);
        }
        catch (Exception ex) {
            this.getLogger().log(Level.SEVERE, "Camel connect failed with EException : ", ex);
        }
    }

    public void deactivate() {
        this.base.close();
    }

    public void shutdown() {
        this.getLogger().log(Level.FINE, "CamelDestination shutdown()");
        this.deactivate();
    }

    protected void incoming(Exchange exchange) {
        this.getLogger().log(Level.FINE, "server received request: ", exchange);
        byte[] bytes = this.base.unmarshal(exchange);
        MessageImpl inMessage = new MessageImpl();
        inMessage.setContent(InputStream.class, (Object)new ByteArrayInputStream(bytes));
        this.base.populateIncomingContext(exchange, inMessage, "org.apache.cxf.camel.server.request.headers");
        inMessage.put((Object)"org.apache.cxf.camel.request.message", (Object)exchange);
        inMessage.setDestination((Destination)this);
        this.incomingObserver.onMessage((Message)inMessage);
    }

    public String getBeanName() {
        return this.endpointInfo.getName().toString() + ".camel-destination";
    }

    private void initConfig() {
    }

    protected String getReplyToDestination(Message inMessage) {
        if (inMessage.get((Object)"org.apache.cxf.camel.server.replyto") != null) {
            return (String)inMessage.get((Object)"org.apache.cxf.camel.server.replyto");
        }
        return this.base.getReplyDestination();
    }

    protected void setReplyCorrelationID(Message inMessage, Exchange reply) {
        Object value = inMessage.get((Object)"org.apache.cxf.camel.correlationId");
        if (value != null) {
            reply.getIn().setHeader("org.apache.cxf.camel.correlationId", value);
        }
    }

    private class CamelOutputStream
    extends CachedOutputStream {
        private Message inMessage;
        private Producer<Exchange> replyTo;
        private Producer<Exchange> sender;

        public CamelOutputStream(Message m) {
            this.inMessage = m;
        }

        private void commitOutputMessage() throws IOException {
            final String replyToUri = CamelDestination.this.getReplyToDestination(this.inMessage);
            ((CamelDestination)CamelDestination.this).base.template.send(replyToUri, new Processor(){

                public void process(Exchange reply) {
                    CamelDestination.this.base.marshal(CamelOutputStream.this.currentStream.toString(), replyToUri, reply);
                    CamelDestination.this.setReplyCorrelationID(CamelOutputStream.this.inMessage, reply);
                    CamelDestination.this.base.setMessageProperties(CamelOutputStream.this.inMessage, reply);
                    CamelDestination.this.getLogger().log(Level.FINE, "just server sending reply: ", reply);
                }
            });
        }

        protected void doFlush() throws IOException {
        }

        protected void doClose() throws IOException {
            this.commitOutputMessage();
        }

        protected void onWrite() throws IOException {
        }
    }

    protected class BackChannelConduit
    extends AbstractConduit {
        protected Message inMessage;

        BackChannelConduit(EndpointReferenceType ref, Message message) {
            super(ref);
            this.inMessage = message;
        }

        public void setMessageObserver(MessageObserver observer) {
        }

        public void prepare(Message message) throws IOException {
            message.put((Object)"org.apache.cxf.camel.request.message", this.inMessage.get((Object)"org.apache.cxf.camel.request.message"));
            message.setContent(OutputStream.class, (Object)new CamelOutputStream(this.inMessage));
        }

        protected Logger getLogger() {
            return LOG;
        }
    }

    protected class ConsumerProcessor
    implements Processor {
        protected ConsumerProcessor() {
        }

        public void process(Exchange exchange) {
            try {
                CamelDestination.this.incoming(exchange);
            }
            catch (Throwable ex) {
                CamelDestination.this.getLogger().log(Level.WARNING, "Failed to process incoming message : ", ex);
            }
        }
    }
}

