/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.invoker;

import java.util.Collection;
import java.util.SortedSet;
import org.apache.camel.component.cxf.interceptors.FaultOutInterceptor;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.AbstractFaultChainInitiatorObserver;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.phase.Phase;
import org.apache.cxf.phase.PhaseInterceptorChain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FaultChainInitiatorObserver
extends AbstractFaultChainInitiatorObserver {
    private SortedSet<Phase> phases;
    private boolean isOutbound;

    public FaultChainInitiatorObserver(Bus bus, SortedSet<Phase> phases, boolean isOutbound) {
        super(bus);
        this.phases = phases;
        this.isOutbound = isOutbound;
    }

    protected void initializeInterceptors(Exchange ex, PhaseInterceptorChain chain) {
        Endpoint e = (Endpoint)ex.get(Endpoint.class);
        if (this.isOutboundObserver()) {
            chain.add((Collection)e.getOutFaultInterceptors());
            chain.add((Collection)e.getBinding().getOutFaultInterceptors());
            chain.add((Collection)e.getService().getOutFaultInterceptors());
            chain.add((Collection)this.getBus().getOutFaultInterceptors());
            chain.add((Interceptor)new FaultOutInterceptor());
        } else {
            chain.add((Collection)e.getBinding().getInFaultInterceptors());
            chain.add((Collection)e.getService().getInFaultInterceptors());
            chain.add((Collection)this.getBus().getInFaultInterceptors());
        }
    }

    protected SortedSet<Phase> getPhases() {
        return this.phases;
    }

    protected boolean isOutboundObserver() {
        return this.isOutbound;
    }
}

