/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.invoker;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.camel.component.cxf.invoker.InvokingContext;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.endpoint.ClientImpl;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.transport.MessageObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CxfClient
extends ClientImpl {
    private static final Logger LOG = Logger.getLogger(CxfClient.class.getName());
    private Endpoint endpoint;

    public CxfClient(Bus b, Endpoint e) {
        super(b, e);
        this.endpoint = e;
    }

    public Object dispatch(Object params, Map<String, Object> context, Exchange exchange) throws Exception {
        BindingInfo bi;
        Object retval = null;
        InvokingContext invokingContext = (InvokingContext)exchange.get(InvokingContext.class);
        assert (invokingContext != null);
        BindingOperationInfo inBoundOp = (BindingOperationInfo)exchange.get(BindingOperationInfo.class);
        BindingOperationInfo outBoundOp = null;
        if (inBoundOp != null && (outBoundOp = (bi = this.getEndpoint().getEndpointInfo().getBinding()).getOperation(inBoundOp.getOperationInfo().getName())) != null && inBoundOp.isUnwrapped()) {
            outBoundOp = outBoundOp.getUnwrappedOperation();
        }
        retval = this.invokeWithMessageStream(outBoundOp, params, context, invokingContext);
        return retval;
    }

    public Object invokeWithMessageStream(BindingOperationInfo bi, Object param, Map<String, Object> context, InvokingContext invokingContext) throws Exception {
        Object retval = null;
        Map requestContext = null;
        Map responseContext = null;
        if (null != context) {
            requestContext = (Map)context.get("RequestContext");
            responseContext = (Map)context.get("ResponseContext");
        }
        ExchangeImpl exchange = new ExchangeImpl();
        exchange.put(MessageObserver.class, (Object)this);
        exchange.put(InvokingContext.class, (Object)invokingContext);
        exchange.put(Bus.class, (Object)this.bus);
        exchange.put(Endpoint.class, (Object)this.getEndpoint());
        exchange.put(BindingInfo.class, (Object)this.getEndpoint().getEndpointInfo().getBinding());
        if (bi != null) {
            exchange.put(BindingOperationInfo.class, (Object)bi);
            exchange.put(BindingMessageInfo.class, (Object)bi.getInput());
            exchange.setOneWay(bi.getOperationInfo().isOneWay());
        }
        Message message = this.prepareMessage((Exchange)exchange, requestContext, param, invokingContext);
        PhaseInterceptorChain chain = this.setupOutChain(requestContext, message, invokingContext);
        this.prepareConduitSelector(message);
        chain.doIntercept(message);
        Exception ex = (Exception)message.getContent(Exception.class);
        if (ex != null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Exception in outgoing chain: " + ex.toString());
            }
            throw ex;
        }
        if (!exchange.isOneWay()) {
            ex = this.getException((Exchange)exchange);
            if (ex != null) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Exception in incoming chain: " + ex.toString());
                }
                throw ex;
            }
            retval = invokingContext.getResponseObject((Exchange)exchange, responseContext);
        }
        return retval;
    }

    public void onMessage(Message message) {
        Exchange exchange = message.getExchange();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("call the cxf client on message , exchange is " + exchange);
        }
        if (exchange.get(InvokingContext.class) == null) {
            super.onMessage(message);
        } else {
            message = this.getEndpoint().getBinding().createMessage(message);
            message.put((Object)"org.apache.cxf.client", (Object)Boolean.TRUE);
            message.put((Object)"org.apache.cxf.message.inbound", (Object)Boolean.TRUE);
            exchange.put(Binding.class, (Object)this.getEndpoint().getBinding());
            BindingOperationInfo bi = (BindingOperationInfo)exchange.get(BindingOperationInfo.class);
            if (bi != null) {
                exchange.put(BindingMessageInfo.class, (Object)bi.getOutput());
            }
            InvokingContext invokingContext = (InvokingContext)exchange.get(InvokingContext.class);
            assert (invokingContext != null);
            PhaseInterceptorChain chain = invokingContext.getResponseInInterceptorChain(exchange);
            message.setInterceptorChain((InterceptorChain)chain);
            chain.doIntercept(message);
            exchange.setInMessage(message);
        }
    }

    private Message prepareMessage(Exchange exchange, Map<String, Object> requestContext, Object param, InvokingContext InvokingContext2) {
        Message message = this.getEndpoint().getBinding().createMessage();
        message.put((Object)"org.apache.cxf.client", (Object)Boolean.TRUE);
        message.put((Object)"org.apache.cxf.message.inbound", (Object)Boolean.FALSE);
        if (requestContext != null) {
            message.putAll(requestContext);
        }
        if (param != null) {
            InvokingContext2.setRequestOutMessageContent(message, param);
        }
        if (null != requestContext) {
            exchange.putAll(requestContext);
        }
        exchange.setOutMessage(message);
        return message;
    }

    private PhaseInterceptorChain setupOutChain(Map<String, Object> requestContext, Message message, InvokingContext invokingContext) {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Build an out interceptor chain to send request to server");
        }
        Exchange exchange = message.getExchange();
        PhaseInterceptorChain chain = invokingContext.getRequestOutInterceptorChain(exchange);
        message.setInterceptorChain((InterceptorChain)chain);
        this.modifyChain((InterceptorChain)chain, requestContext);
        chain.setFaultObserver((MessageObserver)this.outFaultObserver);
        return chain;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public Bus getBus() {
        return this.bus;
    }
}

