/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.invoker;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.camel.component.cxf.invoker.InvokingContext;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.EndpointImpl;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.Phase;
import org.apache.cxf.phase.PhaseInterceptorChain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInvokingContext
implements InvokingContext {
    private static final Logger LOG = Logger.getLogger(AbstractInvokingContext.class.getName());

    @Override
    public PhaseInterceptorChain getRequestInInterceptorChain(Exchange exchange) {
        return this.getInInterceptorChain(exchange, false);
    }

    protected PhaseInterceptorChain getInInterceptorChain(Exchange exchange, boolean isResponse) {
        Bus bus = (Bus)exchange.get(Bus.class);
        assert (bus != null);
        PhaseInterceptorChain chain = new PhaseInterceptorChain(this.getInPhases());
        if (!isResponse) {
            List<Interceptor> routingInterceptors = this.getRoutingInterceptors();
            chain.add(routingInterceptors);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Injected " + routingInterceptors);
            }
        }
        List list = bus.getInInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by bus: " + list);
        }
        chain.add((Collection)list);
        Endpoint ep = (Endpoint)exchange.get(Endpoint.class);
        if (ep != null) {
            list = ep.getInInterceptors();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Interceptors contributed by endpoint: " + list);
            }
            chain.add((Collection)list);
            list = ep.getBinding().getInInterceptors();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Interceptors contributed by binding: " + list);
            }
            chain.add((Collection)list);
            list = ep.getService().getInInterceptors();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Interceptors contributed by service: " + list);
            }
            chain.add((Collection)list);
        }
        return chain;
    }

    protected abstract List<Interceptor> getRoutingInterceptors();

    protected abstract SortedSet<Phase> getInPhases();

    @Override
    public PhaseInterceptorChain getResponseInInterceptorChain(Exchange exchange) {
        return this.getInInterceptorChain(exchange, true);
    }

    protected <T> T getResponseObject(Message inMessage, Map<String, Object> responseContext, Class<T> clazz) {
        Object retval = null;
        if (inMessage != null) {
            if (null != responseContext) {
                responseContext.putAll((Map<String, Object>)inMessage);
                LOG.info("set responseContext to be" + responseContext);
            }
            retval = inMessage.getContent(clazz);
        }
        return (T)retval;
    }

    @Override
    public void setEndpointFaultObservers(EndpointImpl endpointImpl, Bus bus) {
    }
}

