/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import java.io.InputStream;
import javax.wsdl.Definition;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.cxf.CxfSoapConsumer;
import org.apache.camel.component.cxf.CxfSoapProducer;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.helpers.DOMUtils;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.w3c.dom.Document;

public class CxfSoapEndpoint
implements Endpoint {
    private final Endpoint endpoint;
    private Resource wsdl;
    private Document description;
    private Definition definition;
    private QName service;
    private Bus bus;

    public CxfSoapEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    protected Endpoint getInnerEndpoint() {
        return this.endpoint;
    }

    public boolean isSingleton() {
        return this.endpoint.isSingleton();
    }

    public String getEndpointUri() {
        return this.endpoint.getEndpointUri();
    }

    public Exchange createExchange() {
        return this.endpoint.createExchange();
    }

    public Exchange createExchange(ExchangePattern pattern) {
        return this.endpoint.createExchange(pattern);
    }

    public Exchange createExchange(Exchange exchange) {
        return this.endpoint.createExchange(exchange);
    }

    public CamelContext getContext() {
        return this.endpoint.getContext();
    }

    public Producer createProducer() throws Exception {
        return new CxfSoapProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new CxfSoapConsumer(this, processor);
    }

    public PollingConsumer createPollingConsumer() throws Exception {
        throw new UnsupportedOperationException();
    }

    public void setWsdl(Resource wsdl) {
        this.wsdl = wsdl;
    }

    public void init() throws Exception {
        Assert.notNull((Object)this.wsdl, (String)"soap.wsdl parameter must be set on the uri");
        this.description = DOMUtils.readXml((InputStream)this.wsdl.getInputStream());
        WSDLFactory wsdlFactory = WSDLFactory.newInstance();
        WSDLReader reader = wsdlFactory.newWSDLReader();
        reader.setFeature("javax.wsdl.verbose", false);
        this.definition = reader.readWSDL(this.wsdl.getURL().toString(), this.description);
        this.service = (QName)this.definition.getServices().keySet().iterator().next();
    }

    protected Bus getBus() {
        if (this.bus == null) {
            this.bus = BusFactory.newInstance().createBus();
        }
        return this.bus;
    }

    public Definition getDefinition() {
        return this.definition;
    }

    public QName getService() {
        return this.service;
    }
}

