/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import java.util.List;
import org.apache.camel.CamelException;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.cxf.CxfBinding;
import org.apache.camel.component.cxf.CxfEndpoint;
import org.apache.camel.component.cxf.CxfExchange;
import org.apache.camel.component.cxf.DataFormat;
import org.apache.camel.component.cxf.invoker.CxfClient;
import org.apache.camel.component.cxf.invoker.CxfClientFactoryBean;
import org.apache.camel.component.cxf.invoker.InvokingContext;
import org.apache.camel.component.cxf.util.CxfEndpointUtils;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.frontend.ClientFactoryBean;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.model.BindingOperationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CxfProducer
extends DefaultProducer<CxfExchange> {
    private CxfEndpoint endpoint;
    private Client client;
    private DataFormat dataFormat;

    public CxfProducer(CxfEndpoint endpoint) throws CamelException {
        super(endpoint);
        this.endpoint = endpoint;
        this.dataFormat = CxfEndpointUtils.getDataFormat(endpoint);
        this.client = this.dataFormat.equals((Object)DataFormat.POJO) ? this.createClientFormClientFactoryBean(null) : this.createClientForStreamMessge();
    }

    private Client createClientForStreamMessge() throws CamelException {
        CxfClientFactoryBean cfb = new CxfClientFactoryBean();
        if (null != this.endpoint.getServiceClass()) {
            try {
                Class serviceClass = ClassLoaderUtils.loadClass((String)this.endpoint.getServiceClass(), this.getClass());
                boolean jsr181Enabled = CxfEndpointUtils.hasWebServiceAnnotation(serviceClass);
                cfb.setJSR181Enabled(jsr181Enabled);
            }
            catch (ClassNotFoundException e) {
                throw new CamelException(e);
            }
        }
        return this.createClientFormClientFactoryBean(cfb);
    }

    /*
     * Unable to fully structure code
     */
    private Client createClientFormClientFactoryBean(ClientFactoryBean cfb) throws CamelException {
        bus = BusFactory.getDefaultBus();
        if (this.endpoint.isSpringContextEndpoint()) {
            endpointBean = this.endpoint.getCxfEndpointBean();
            if (cfb == null) {
                cfb = CxfEndpointUtils.getClientFactoryBean(endpointBean.getServiceClass());
            }
            this.endpoint.configure(cfb);
            cxfEndpointBean = this.endpoint.getCxfEndpointBean();
            if (cxfEndpointBean.getServiceName() != null) {
                cfb.getServiceFactory().setServiceName(cxfEndpointBean.getServiceName());
            }
            if (cxfEndpointBean.getEndpointName() != null) {
                cfb.getServiceFactory().setEndpointName(cxfEndpointBean.getEndpointName());
            }
        } else {
            if (null != this.endpoint.getServiceClass()) {
                try {
                    serviceClass = ClassLoaderUtils.loadClass((String)this.endpoint.getServiceClass(), this.getClass());
                    if (cfb == null) {
                        cfb = CxfEndpointUtils.getClientFactoryBean(serviceClass);
                    }
                    cfb.setAddress(this.endpoint.getAddress());
                    if (null != this.endpoint.getServiceClass()) {
                        cfb.setServiceClass(ObjectHelper.loadClass(this.endpoint.getServiceClass()));
                    }
                    if (null == this.endpoint.getWsdlURL()) ** GOTO lbl32
                    cfb.setWsdlURL(this.endpoint.getWsdlURL());
                }
                catch (ClassNotFoundException e) {
                    throw new CamelException(e);
                }
            } else {
                if (cfb == null) {
                    cfb = new ClientFactoryBean();
                }
                if (null != this.endpoint.getWsdlURL()) {
                    cfb.setWsdlURL(this.endpoint.getWsdlURL());
                } else {
                    throw new CamelException("Insufficiency of the endpoint info");
                }
            }
lbl32:
            // 3 sources

            if (this.endpoint.getServiceName() != null) {
                cfb.getServiceFactory().setServiceName(CxfEndpointUtils.getServiceName(this.endpoint));
            }
            if (this.endpoint.getPortName() != null) {
                cfb.getServiceFactory().setEndpointName(CxfEndpointUtils.getPortName(this.endpoint));
            }
            if (this.endpoint.getWsdlURL() != null) {
                cfb.setWsdlURL(this.endpoint.getWsdlURL());
            }
        }
        cfb.setBus(bus);
        return cfb.create();
    }

    @Override
    public void process(Exchange exchange) {
        CxfExchange cxfExchange = (CxfExchange)this.endpoint.createExchange(exchange);
        this.process(cxfExchange);
    }

    public void process(CxfExchange exchange) {
        CxfBinding cxfBinding = this.endpoint.getBinding();
        Message inMessage = cxfBinding.createCxfMessage(exchange);
        try {
            if (this.dataFormat.equals((Object)DataFormat.POJO)) {
                List paraments = (List)inMessage.getContent(List.class);
                String operation = (String)inMessage.getContent(String.class);
                MessageImpl response = new MessageImpl();
                if (operation != null && paraments != null) {
                    try {
                        Object[] result = this.client.invoke(operation, paraments.toArray());
                        response.setContent(Object[].class, (Object)result);
                        cxfBinding.storeCxfResponse(exchange, (Message)response);
                    }
                    catch (Exception ex) {
                        response.setContent(Exception.class, (Object)ex);
                        cxfBinding.storeCxfFault(exchange, (Message)response);
                    }
                }
            } else {
                org.apache.cxf.message.Exchange ex = exchange.getExchange();
                InvokingContext invokingContext = (InvokingContext)ex.get(InvokingContext.class);
                Object params = invokingContext.getRequestContent(inMessage);
                CxfClient cxfClient = (CxfClient)this.client;
                Object result = cxfClient.dispatch(params, null, ex);
                BindingOperationInfo boi = (BindingOperationInfo)ex.get(BindingOperationInfo.class);
                MessageImpl response = null;
                if (boi == null) {
                    response = new MessageImpl();
                } else {
                    Endpoint ep = (Endpoint)ex.get(Endpoint.class);
                    response = ep.getBinding().createMessage();
                }
                response.setExchange(ex);
                ex.setOutMessage((Message)response);
                invokingContext.setResponseContent((Message)response, result);
                cxfBinding.storeCxfResponse(exchange, (Message)response);
            }
        }
        catch (Exception e) {
            throw new RuntimeCamelException(e);
        }
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
    }
}

