/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import java.util.Map;
import org.apache.camel.component.cxf.CxfExchange;
import org.apache.camel.impl.DefaultMessage;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CxfMessage
extends DefaultMessage {
    private Message cxfMessage;

    public CxfMessage() {
        this((Message)new MessageImpl());
    }

    public CxfMessage(Message cxfMessage) {
        if (cxfMessage == null) {
            this.cxfMessage = new MessageImpl();
        }
        this.cxfMessage = cxfMessage;
    }

    @Override
    public String toString() {
        if (this.cxfMessage != null) {
            return "CxfMessage: " + this.cxfMessage;
        }
        return "CxfMessage: " + this.getBody();
    }

    @Override
    public CxfExchange getExchange() {
        return (CxfExchange)super.getExchange();
    }

    public Message getMessage() {
        return this.cxfMessage;
    }

    public void setMessage(Message cxfMessage) {
        this.cxfMessage = cxfMessage;
    }

    @Override
    public Object getHeader(String name) {
        return this.cxfMessage.get((Object)name);
    }

    @Override
    public void setHeader(String name, Object value) {
        this.cxfMessage.put((Object)name, value);
    }

    @Override
    public Map<String, Object> getHeaders() {
        return this.cxfMessage;
    }

    @Override
    public CxfMessage newInstance() {
        return new CxfMessage();
    }

    @Override
    protected Object createBody() {
        return this.getExchange().getBinding().extractBodyFromCxf(this.getExchange(), this.cxfMessage);
    }
}

