/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.camel.component.cxf.CxfConsumer;
import org.apache.camel.component.cxf.CxfEndpoint;
import org.apache.camel.component.cxf.CxfExchange;
import org.apache.camel.component.cxf.CxfMessage;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.frontend.MethodDispatcher;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.service.model.BindingOperationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CamelInvoker
implements Invoker {
    private static final Logger LOG = Logger.getLogger(CamelInvoker.class.getName());
    private CxfConsumer cxfConsumer;

    public CamelInvoker(CxfConsumer consumer) {
        this.cxfConsumer = consumer;
    }

    public Message invoke(Message inMessage) {
        System.out.println("invoke the message " + inMessage);
        Exchange exchange = inMessage.getExchange();
        HashMap<String, HashMap<String, Object>> ctxContainer = new HashMap<String, HashMap<String, Object>>();
        HashMap<String, Object> requestCtx = new HashMap<String, Object>();
        ctxContainer.put("RequestContext", requestCtx);
        this.updateContext((Map<String, Object>)inMessage, requestCtx);
        CxfEndpoint endpoint = this.cxfConsumer.getEndpoint();
        CxfExchange cxfExchange = endpoint.createExchange(inMessage);
        try {
            this.cxfConsumer.getProcessor().process(cxfExchange);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Message outMessage = this.getCxfMessage(cxfExchange, exchange);
        return outMessage;
    }

    public Message getCxfMessage(CxfExchange result, Exchange exchange) {
        Message outMessage = null;
        if (result.isFailed()) {
            CxfMessage fault = result.getFault();
            outMessage = exchange.getInFaultMessage();
            if (outMessage == null) {
                outMessage = new MessageImpl();
                exchange.setInFaultMessage(outMessage);
            }
            Exception ex = (Exception)fault.getBody();
            outMessage.setContent(Exception.class, (Object)ex);
        } else {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Payload is a response.");
            }
            if ((outMessage = result.getOutMessage()) == null) {
                Endpoint ep = (Endpoint)exchange.get(Endpoint.class);
                outMessage = ep.getBinding().createMessage();
                exchange.setOutMessage(outMessage);
            }
        }
        return outMessage;
    }

    public void updateContext(Map<String, Object> from, Map<String, Object> to) {
        if (to != null && from != null) {
            for (Map.Entry<String, Object> entry : from.entrySet()) {
                String key = entry.getKey();
                if ("org.apache.cxf.message.inbound".equals(key) || "org.apache.cxf.client".equals(key) || Message.PROTOCOL_HEADERS.equals(key)) continue;
                to.put(key, entry.getValue());
            }
        }
    }

    public Object invoke(Exchange exchange, Object o) {
        BindingOperationInfo bop = (BindingOperationInfo)exchange.get(BindingOperationInfo.class);
        MethodDispatcher md = (MethodDispatcher)((Service)exchange.get(Service.class)).get((Object)MethodDispatcher.class.getName());
        Method m = md.getMethod(bop);
        List params = null;
        if (o instanceof List) {
            params = CastUtils.cast((List)((List)o));
        } else if (o != null) {
            params = new MessageContentsList(new Object[]{o});
        }
        CxfEndpoint endpoint = this.cxfConsumer.getEndpoint();
        CxfExchange cxfExchange = endpoint.createExchange(exchange.getInMessage());
        cxfExchange.getIn().setHeader("operationName", m.getName());
        cxfExchange.getIn().setBody(params);
        try {
            this.cxfConsumer.getProcessor().process(cxfExchange);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (cxfExchange.isFailed()) {
            Exception ex = (Exception)cxfExchange.getFault().getBody();
            throw new Fault((Throwable)ex);
        }
        Object[] result = (Object[])cxfExchange.getOut().getBody();
        return result;
    }
}

