/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.model.ProcessorType;
import org.apache.camel.spi.Language;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionClause<T extends ProcessorType> {
    private T result;
    private CamelContext camelContext;

    public T el(String text) {
        return this.language("el", text);
    }

    public T groovy(String text) {
        return this.language("groovy", text);
    }

    public T javaScript(String text) {
        return this.language("js", text);
    }

    public T ognl(String text) {
        return this.language("ognl", text);
    }

    public T php(String text) {
        return this.language("php", text);
    }

    public T python(String text) {
        return this.language("python", text);
    }

    public T ruby(String text) {
        return this.language("ruby", text);
    }

    public T sql(String text) {
        return this.language("sql", text);
    }

    public T simple(String text) {
        return this.language("simple", text);
    }

    public T xpath(String text) {
        return this.language("xpath", text);
    }

    public T xqery(String text) {
        return this.language("xqery", text);
    }

    public T language(String languageName, String text) {
        Expression expression = this.createExpression("el", text);
        return this.result;
    }

    protected Expression createExpression(String languageName, String text) {
        Language language = this.camelContext.resolveLanguage(languageName);
        if (language == null) {
            throw new IllegalArgumentException("Could not resolve language: " + languageName);
        }
        return language.createExpression(text);
    }
}

