/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.model.ProcessorType;
import org.apache.camel.model.dataformat.ArtixDSContentType;
import org.apache.camel.model.dataformat.ArtixDSDataFormat;
import org.apache.camel.model.dataformat.DataFormatType;
import org.apache.camel.model.dataformat.JaxbDataFormat;
import org.apache.camel.model.dataformat.SerializationDataFormat;
import org.apache.camel.model.dataformat.XMLBeansDataFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataTypeExpression<T extends ProcessorType> {
    private final ProcessorType<T> processorType;
    private final Operation operation;

    public DataTypeExpression(ProcessorType<T> processorType, Operation operation) {
        this.processorType = processorType;
        this.operation = operation;
    }

    public T serialization() {
        return this.dataFormat(new SerializationDataFormat());
    }

    public T jaxb() {
        return this.dataFormat(new JaxbDataFormat());
    }

    public T jaxb(boolean prettyPrint) {
        return this.dataFormat(new JaxbDataFormat(prettyPrint));
    }

    public T xmlBeans() {
        return this.dataFormat(new XMLBeansDataFormat());
    }

    public T artixDS() {
        return this.dataFormat(new ArtixDSDataFormat());
    }

    public T artixDS(Class<?> dataObjectType) {
        return this.dataFormat(new ArtixDSDataFormat(dataObjectType));
    }

    public T artixDS(Class<?> elementType, ArtixDSContentType contentType) {
        return this.dataFormat(new ArtixDSDataFormat(elementType, contentType));
    }

    public T artixDS(ArtixDSContentType contentType) {
        return this.dataFormat(new ArtixDSDataFormat(contentType));
    }

    private T dataFormat(DataFormatType dataFormatType) {
        switch (this.operation) {
            case Unmarshal: {
                return this.processorType.unmarshal(dataFormatType);
            }
            case Marshal: {
                return this.processorType.marshal(dataFormatType);
            }
        }
        throw new IllegalArgumentException("Unknown value: " + (Object)((Object)this.operation));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operation {
        Marshal,
        Unmarshal;

    }
}

