/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ExchangePattern {
    InOnly,
    RobustInOnly,
    InOut,
    InOptionalOut,
    OutOnly,
    RobustOutOnly,
    OutIn,
    OutOptionalIn;

    protected static final Map<String, ExchangePattern> map;

    public String getWsdlUri() {
        switch (this) {
            case InOnly: {
                return "http://www.w3.org/ns/wsdl/in-only";
            }
            case InOptionalOut: {
                return "http://www.w3.org/ns/wsdl/in-optional-out";
            }
            case InOut: {
                return "http://www.w3.org/ns/wsdl/in-out";
            }
            case OutIn: {
                return "http://www.w3.org/ns/wsdl/out-in";
            }
            case OutOnly: {
                return "http://www.w3.org/ns/wsdl/out-only";
            }
            case OutOptionalIn: {
                return "http://www.w3.org/ns/wsdl/out-optional_in";
            }
            case RobustInOnly: {
                return "http://www.w3.org/ns/wsdl/robust-in-only";
            }
            case RobustOutOnly: {
                return "http://www.w3.org/ns/wsdl/robust-out-only";
            }
        }
        throw new IllegalArgumentException("Unknown message exchange pattern: " + (Object)((Object)this));
    }

    public boolean isInCapable() {
        switch (this) {
            case OutOnly: 
            case RobustOutOnly: {
                return true;
            }
        }
        return false;
    }

    public boolean isOutCapable() {
        switch (this) {
            case InOnly: 
            case RobustInOnly: {
                return false;
            }
        }
        return true;
    }

    public boolean isFaultCapable() {
        switch (this) {
            case InOnly: 
            case OutOnly: {
                return false;
            }
        }
        return true;
    }

    public static ExchangePattern fromWsdlUri(String wsdlUri) {
        return map.get(wsdlUri);
    }

    static {
        map = new HashMap<String, ExchangePattern>();
        for (ExchangePattern mep : ExchangePattern.values()) {
            String uri = mep.getWsdlUri();
            map.put(uri, mep);
            String name = uri.substring(uri.lastIndexOf(47));
            map.put("http://www.w3.org/2004/08/wsdl/" + name, mep);
            map.put("http://www.w3.org/2006/01/wsdl/" + name, mep);
        }
    }
}

