/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.Collection;
import org.apache.camel.Service;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServiceHelper {
    private static final transient Log LOG = LogFactory.getLog(ServiceHelper.class);

    private ServiceHelper() {
    }

    public static void startService(Object value) throws Exception {
        if (value instanceof Service) {
            Service service = (Service)value;
            service.start();
        } else if (value instanceof Collection) {
            ServiceHelper.startServices((Collection)value);
        }
    }

    public static void startServices(Object ... services) throws Exception {
        for (Object value : services) {
            ServiceHelper.startService(value);
        }
    }

    public static void startServices(Collection services) throws Exception {
        for (Object value : services) {
            if (!(value instanceof Service)) continue;
            Service service = (Service)value;
            service.start();
        }
    }

    public static void stopServices(Object ... services) throws Exception {
        Exception firstException = null;
        for (Object value : services) {
            if (!(value instanceof Service)) continue;
            Service service = (Service)value;
            try {
                service.stop();
            }
            catch (Exception e) {
                LOG.debug("Caught exception shutting down: " + e, e);
                if (firstException != null) continue;
                firstException = e;
            }
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    public static void stopService(Object value) throws Exception {
        if (value instanceof Service) {
            Service service = (Service)value;
            service.stop();
        } else if (value instanceof Collection) {
            ServiceHelper.stopServices((Collection)value);
        }
    }

    public static void stopServices(Collection services) throws Exception {
        Exception firstException = null;
        for (Object value : services) {
            if (!(value instanceof Service)) continue;
            Service service = (Service)value;
            try {
                service.stop();
            }
            catch (Exception e) {
                LOG.debug("Caught exception shutting down: " + e, e);
                if (firstException != null) continue;
                firstException = e;
            }
        }
        if (firstException != null) {
            throw firstException;
        }
    }
}

